package com.edgec.browserbackend.browser.service;

import com.edgec.browserbackend.browser.domain.*;
import com.edgec.browserbackend.browser.dto.*;

import java.util.List;

public interface IpResourceService {

    List<String> buyIp(String username, IpResourceRequestDto ipResourceRequestDto) throws Exception;

    IpOperationResultDto renewIp(String username, IpResourceRequestDto ipResourceRequestDto) throws Exception;

    IpOperationResultDto deleteIp(String username, IpResourceRequestDto ipResourceRequestDto) throws Exception;

    IpPageResultDto getIpList(String username, int groupType, int page, int amount, IpFilterDto ipFilterDto);

    void setIpOptions();

    IpOptions getIpOptions();

    List<PlatformOptions> getPlatformOptions();

    IpSummary getIpSummary(String username);

    void updateIp(String username, IpResourceUpdateDto ipResourceUpdateDto);

    boolean queryIpExist(String username, IpResourceUpdateDto ipResourceUpdateDto);

    IpResourceDto queryIp(String username, IpResourceRequestDto ipResourceRequestDto);

    void setSpecialLine();

    void releaseDeletedIp();
}
