package com.edgec.browserbackend.common.commons.utils;


import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import java.util.Date;


public class DateConverter {

    public static final String DATE_PATTERN = "yyyy-MM-dd";

    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd hh:mm:ss";

    public static final String DATE_TIME_PATTERN_ALI = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public static final String DATE_TIME_PATTERN_TENCENT = "yyyy-MM-dd HH:mm:ss";

    private static final DateTimeFormatter dateFormatter = DateTimeFormat.forPattern(DATE_PATTERN);

    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern(DATE_TIME_PATTERN);

    private static final DateTimeFormatter dateTimeFormatter_ali = DateTimeFormat.forPattern(DATE_TIME_PATTERN_ALI);

    private static final DateTimeFormatter dateTimeFormatter_tencent = DateTimeFormat.forPattern(DATE_TIME_PATTERN_TENCENT);


    public static Date stringToDate(String date) {
        try {
            return dateFormatter.parseDateTime(date).toDate();
        } catch (Exception e) {
            return dateTimeFormatter.parseDateTime(date).toDate();
        }
    }

    public static String dateToString(Date date) {
        DateTime dateTime = new DateTime(date);
        return dateTimeFormatter.print(dateTime);
    }

    public static long stringToLongAli(String date) {
        try {
            return dateTimeFormatter_ali.parseDateTime(date).getMillis();
        } catch (Exception e) {
            return dateTimeFormatter_ali.parseDateTime(date).getMillis();
        }
    }

    public static long stringToLongTencent(String date) {
        try {
            return dateTimeFormatter_tencent.parseDateTime(date).getMillis();
        } catch (Exception e) {
            return dateTimeFormatter_tencent.parseDateTime(date).getMillis();
        }
    }


}
