package com.edgec.browserbackend.common.utils;

import com.edgec.browserbackend.common.commons.utils.NotifyUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.impl.client.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Trans {
    private final Logger logger = LoggerFactory.getLogger(Trans.class);
    static int timeout = 10 * 1000;// 以秒为单位
    private static String specialHost = "39.108.183.128";
    private static int specialPort = 20008;
    private String host;
    private int port;
    private String username;
    private String password;

    public Trans(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.password = password;
        this.username = username;
    }

    public Trans(String username, String password) {
        this.host = specialHost;
        this.port = specialPort;
        this.password = password;
        this.username = username;
    }

    /**
     * 主入口方法
     * @param args
     */
    public static void main(String[] args) {
        String url = "http://pv.sohu.com/cityjson";
        Trans trans = new Trans("120.76.135.212", 20001, "fangguanlianbrowser", "2rbvtg9GQ1JraA1");
    }

    /**
     * 向指定URL发送GET方法的请求
     */
    public String get(String url) {
        StringBuffer sb = new StringBuffer();
        HttpHost proxy = new HttpHost(host,port);
        // 设置认证
        CredentialsProvider provider = new BasicCredentialsProvider();

        provider.setCredentials(new AuthScope(proxy), new UsernamePasswordCredentials(username, password));
        //创建httpClient实例
        CloseableHttpClient client = HttpClients.custom().setDefaultCredentialsProvider(provider).build();
        //创建httpGet实例
        HttpGet httpGet = new HttpGet(url);
        //设置代理IP，设置连接超时时间 、 设置 请求读取数据的超时时间 、 设置从connect Manager获取Connection超时时间、

        RequestConfig requestConfig = RequestConfig.custom()
                .setProxy(proxy)
                .setConnectTimeout(5000)
                .setSocketTimeout(5000)
                .setConnectionRequestTimeout(5000)
                .build();
        httpGet.setConfig(requestConfig);

        //执行
        try {
            HttpResponse response = client.execute(httpGet);

            HttpEntity entry = response.getEntity();

            if (entry != null) {
                InputStreamReader is = new InputStreamReader(entry.getContent());
                BufferedReader br = new BufferedReader(is);
                String str = null;
                while ((str = br.readLine()) != null) {
                    sb.append(str.trim());
                }
                br.close();
            }
            return sb.toString();
        } catch (ClientProtocolException e) {
            logger.error(e.getMessage(), e);
            return "";
        } catch (IOException e) {
            logger.error(e.getMessage(), e);
            return "";
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            return "";
        }
        finally {
            httpGet.releaseConnection();
        }
    }
}