package com.edgec.browserbackend.account.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection = "realnameauthrecord")
@JsonIgnoreProperties(ignoreUnknown = true)
public class RealnameAuthRecord {

    @Id
    private String shortUrl;

    private String username;

    private long authTime;

    private String longUrl;

    private String certName;

    private String certNo;

    private String certifyId;

    private boolean isSuccess;

    public RealnameAuthRecord() {
    }

    public RealnameAuthRecord(String username, String longUrl, String certName, String certNo, String certifyId, boolean isSuccess){
        this.username = username;
        this.longUrl = longUrl;
        this.certName = certName;
        this.certNo = certNo;
        this.certifyId = certifyId;
        this.isSuccess = isSuccess;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public long getAuthTime() {
        return authTime;
    }

    public void setAuthTime(long authTime) {
        this.authTime = authTime;
    }

    public String getShortUrl() {
        return shortUrl;
    }

    public void setShortUrl(String shortUrl) {
        this.shortUrl = shortUrl;
    }

    public String getCertName() {
        return certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }

    public String getCertNo() {
        return certNo;
    }

    public void setCertNo(String certNo) {
        this.certNo = certNo;
    }

    public String getLongUrl() {
        return longUrl;
    }

    public void setLongUrl(String longUrl) {
        this.longUrl = longUrl;
    }

    public String getCertifyId() {
        return certifyId;
    }

    public void setCertifyId(String certifyId) {
        this.certifyId = certifyId;
    }

    public boolean isSuccess() {
        return isSuccess;
    }

    public void setSuccess(boolean success) {
        isSuccess = success;
    }
}
