package com.edgec.browserbackend.account.service.impl;

import com.edgec.browserbackend.account.service.PayBackService;
import com.edgec.browserbackend.browser.domain.PayBack;
import com.edgec.browserbackend.browser.repository.PayBackRepository;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author xuxin
 * @date 2020/7/24 15:15
 * @description
 */
@Service
public class PayBackServiceImpl implements PayBackService {

    @Autowired
    private PayBackRepository payBackRepository;

    @Override
    public List<PayBack> findAll() {
        return payBackRepository.findAll().stream().sorted(Comparator.comparing(PayBack::getPay)).collect(Collectors.toList());
    }

    @Override
    public List<PayBack> updatePayBack(PayBack payBack) {
        List<PayBack> list = filterPay(payBack.getPay());
        if(list.size() > 0 && payBack.getPay() > 0) {
            list.forEach(payBackRepository::delete);
            payBackRepository.insert(payBack);
        }
        return sortPay();
    }

    @NotNull
    private List<PayBack> filterPay(int pay) {
        return payBackRepository.findAll().stream().filter(x -> x.getPay() == pay).collect(Collectors.toList());
    }

    @Override
    public List<PayBack> createPayBack(PayBack payBack) {
        List<PayBack> list = filterPay(payBack.getPay());
        if(list.size() == 0 && payBack.getPay() > 0){
            payBackRepository.insert(payBack);
        }
        return sortPay();
    }

    @Override
    public List<PayBack> deletePayBack(Integer pay) {
        filterPay(pay).forEach(payBackRepository::delete);
        return sortPay();
    }

    @NotNull
    private List<PayBack> sortPay() {
        return findAll().stream().sorted(Comparator.comparing(PayBack::getPay)).collect(Collectors.toList());
    }
}
