package com.edgec.browserbackend.browser.controller;

import com.edgec.browserbackend.account.dto.NoticeDto;
import com.edgec.browserbackend.account.dto.ResultDto;
import com.edgec.browserbackend.account.service.AdministratorService;
import com.edgec.browserbackend.browser.service.GlobalFieldService;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import com.edgec.browserbackend.common.utils.ResponseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author xuxin
 */
@RestController
@RequestMapping("/globalfield")
public class GlobalFieldController {

    private final Logger log = LoggerFactory.getLogger(GlobalFieldController.class);

    @Autowired
    private GlobalFieldService globalFieldService;

    @Autowired
    private AdministratorService administratorService;

    @GetMapping("/speciallinestate")
    public ResultDto querySpecialLineState() {
        String logs = "【querySpecialLineState】 ";
        try {
            return ResponseUtil.success(globalFieldService.querySpecialLineState());
        } catch (ClientRequestException e) {
            log.warn("{}, ClientRequestException : {}", logs, e.getErrorCode().getReason());
            return ResponseUtil.error(e.getErrorCode());
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            return ResponseUtil.error(e.getMessage());
        }
    }

    /**
     * 查询公告
     */
    @RequestMapping(path = "/getNotice", method = RequestMethod.GET)
    public NoticeDto getNotice() {
        return administratorService.getNotice();
    }
}
