package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.domain.Shop;
import com.edgec.browserbackend.browser.dto.FavoriteUrl;
import com.mongodb.client.result.UpdateResult;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

import static org.springframework.data.mongodb.core.query.Criteria.where;

public class ShopRepositoryCustomImpl implements ShopRepositoryCustom {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public boolean saveFavoritesUrls(String shopId, FavoriteUrl favoriteUrl) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("_id").is(shopId));
        Update update = new Update();
        update.addToSet("favoritesUrls", favoriteUrl);
        UpdateResult result = mongoTemplate.updateFirst(basicQuery, update, Shop.class);
        return result.getModifiedCount() >= 1;
    }

    @Override
    public boolean deleteFavoritesByShopId(String shopId, FavoriteUrl favoriteUrl) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("_id").is(shopId));
        Update update = new Update();
        update.pull("favoritesUrls", Query.query(Criteria.where("url").is(favoriteUrl.getUrl())));
        UpdateResult result = mongoTemplate.updateFirst(basicQuery, update, Shop.class);
        return result.getModifiedCount() >= 1;
    }
}
