package com.edgec.browserbackend.browser.task;

import com.edgec.browserbackend.account.utils.AccountServicePool;
import com.edgec.browserbackend.common.utils.ThreadPoolUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.PreDestroy;
import java.util.concurrent.TimeUnit;


@Component
public class TerminateBean {

    private static final Logger log = LoggerFactory.getLogger(TerminateBean.class);

    @PreDestroy
    public void onDestroy() throws Exception {
        AccountServicePool.taskPool.shutdown();
        ThreadPoolUtils.buyIpTasksPool.shutdown();
        ThreadPoolUtils.queryIpHealth.shutdown();
        ThreadPoolUtils.queryIpTasksPool.shutdown();

        AccountServicePool.taskPool.awaitTermination(5, TimeUnit.MINUTES);
        ThreadPoolUtils.buyIpTasksPool.awaitTermination(5, TimeUnit.MINUTES);
        ThreadPoolUtils.queryIpHealth.awaitTermination(5, TimeUnit.MINUTES);
        ThreadPoolUtils.queryIpTasksPool.awaitTermination(5, TimeUnit.MINUTES);

        log.warn("threadpool is destroyed!!");
    }


}
