package com.edgec.browserbackend.account.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.hibernate.validator.constraints.Length;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@Document(collection = "accounts")
@JsonIgnoreProperties(ignoreUnknown = true)
public class Account {

    @Id
    private String name;

    private String parent;

    //子用户使用
    private String password;

    private Date lastSeen;

    private Date signupDate = new Date();

    private String nickname;

    private String email;

    private String companyName;

    private String jobTitle;

    private String phoneNumber;

    private String lockReason;

    private boolean isPrePaid = true;

    private String token;

    private boolean allowedToCreateSubUser = false;

    private int permission = -1;

    private Promotion promotion;

    private String promotionCode;

    private String comment;

    private List<String> whiteList = new ArrayList<>();

    private int childCount = 0;

    private int groupCount = 0;

    private int shopCount = 0;

    private int authorized; // 0: 未认证; 1: 认证中; 2: 已认证;

    private List<String> queryIpUrlList = new ArrayList<>();

    public Date getSignupDate() {
        return signupDate;
    }

    public void setSignupDate(Date signupDate) {
        this.signupDate = signupDate;
    }

    public boolean isPrePaid() {
        return isPrePaid;
    }

    public void setPrePaid(boolean prePaid) {
        isPrePaid = prePaid;
    }

    public Account() {
    }

    public Account(AccountDto account) {
        this.setName(account.getName());
        this.setAllowedToCreateSubUser(account.isAllowedToCreateSubUser());
        this.setCompanyName(account.getCompanyName());
        this.setEmail(account.getEmail());
        this.setJobTitle(account.getJobTitle());
        this.setPhoneNumber(account.getPhoneNumber());
        this.setPermission(account.getPermission());
        this.setWhiteList(account.getWhiteList());
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getJobTitle() {
        return jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @Length(min = 0, max = 20000)
    private String note;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getLastSeen() {
        return lastSeen;
    }

    public void setLastSeen(Date lastSeen) {
        this.lastSeen = lastSeen;
    }

    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getParent() {
        return parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public boolean isAllowedToCreateSubUser() {
        return allowedToCreateSubUser;
    }

    public void setAllowedToCreateSubUser(boolean allowedToCreateSubUser) {
        this.allowedToCreateSubUser = allowedToCreateSubUser;
    }

    public String getLockReason() {
        return lockReason;
    }

    public void setLockReason(String lockReason) {
        this.lockReason = lockReason;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public int getPermission() {
        return permission;
    }

    public void setPermission(int permission) {
        this.permission = permission;
    }

    public List<String> getWhiteList() {
        return whiteList;
    }

    public void setWhiteList(List<String> whiteList) {
        this.whiteList = whiteList;
    }

    public int getChildCount() {
        return childCount;
    }

    public void setChildCount(int childCount) {
        this.childCount = childCount;
    }

    public int getGroupCount() {
        return groupCount;
    }

    public void setGroupCount(int groupCount) {
        this.groupCount = groupCount;
    }

    public int getShopCount() {
        return shopCount;
    }

    public void setShopCount(int shopCount) {
        this.shopCount = shopCount;
    }

    public Promotion getPromotion() {
        return promotion;
    }

    public void setPromotion(Promotion promotion) {
        this.promotion = promotion;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<String> getQueryIpUrlList() {
        return queryIpUrlList;
    }

    public void setQueryIpUrlList(List<String> queryIpUrlList) {
        this.queryIpUrlList = queryIpUrlList;
    }

    public int getAuthorized() {
        return authorized;
    }

    public void setAuthorized(int authorized) {
        this.authorized = authorized;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPromotionCode() {
        return promotionCode;
    }

    public void setPromotionCode(String promotionCode) {
        this.promotionCode = promotionCode;
    }

}
