package com.edgec.browserbackend.account.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection = "administrator")
@JsonIgnoreProperties(ignoreUnknown = true)
public class Administrator {

    @Id
    private String name;

    private String role; //List<Map<String,Boolean>>

    @Transient
    private String password;


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getPassword() { return password; }

    public void setPassword(String password) {
        this.password = password;
    }



}
