package com.edgec.browserbackend.account.dto;

import com.edgec.browserbackend.account.domain.Account;
import com.edgec.browserbackend.account.domain.Promotion;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AccountPromotionDto {
    private String username;
    private Date signupDate;
    private Promotion promotion;

    public AccountPromotionDto() {

    }

    public AccountPromotionDto(Account account) {
        this.username = account.getName();
        this.signupDate = account.getSignupDate();
        this.promotion = account.getPromotion();
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Date getSignupDate() {
        return signupDate;
    }

    public void setSignupDate(Date signupDate) {
        this.signupDate = signupDate;
    }
}
