package com.edgec.browserbackend.common.commons.utils;

import com.alibaba.fastjson.JSONObject;
import com.edgec.browserbackend.common.commons.core.ApplicationContextProvider;
import com.edgec.browserbackend.common.commons.domain.WeixinMessage;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class NotifyUtils {

    private static final Logger log = LoggerFactory.getLogger(NotifyUtils.class);

    private static final CloseableHttpClient httpClient = HttpClients.createDefault();

    public enum MsgType {
        WEBHOOK("https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=7876986a-40f2-47a5-8071-f8aef21a996c"),
        ;
        String url;

        MsgType(String url) {
            this.url = url;
        }

        public String getCode() {
            return url;
        }

    }

    private static void sendPost(MsgType msgType, JSONObject param) {
        HttpPost httpPost = new HttpPost(msgType.getCode());
        StringEntity requestEntity = new StringEntity(String.valueOf(param), "utf-8");
        requestEntity.setContentEncoding("UTF-8");
        httpPost.setHeader("Content-type", "application/json");
        httpPost.setEntity(requestEntity);
        try {
            CloseableHttpResponse response = httpClient.execute(httpPost);
            response.close();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
        }
    }

    private static void arrangeMessage(MsgType weChatURL, WeixinMessage message) {
        JSONObject json = new JSONObject();
        json.put("msgtype", "text");
        JSONObject text = new JSONObject();
        String env = "main";
        try {
            env = ApplicationContextProvider.getApplicationContext().getEnvironment().getProperty("spring.profiles.active");
        } catch (Exception e) {

        }
        if (!StringUtils.isEmpty(env) && !env.equalsIgnoreCase("prod")) {
            return;
        }
        String envPrefix = "执行环境: " + env + "\n";
        text.put("content", envPrefix + message.getContent());
        json.put("text", text);
        sendPost(weChatURL, json);
    }

    public static void sendMessage(String content, MsgType weChatURL) {
        try {
            WeixinMessage message = new WeixinMessage();
            message.setContent(content);
            arrangeMessage(weChatURL, message);
        } catch (Exception e) {
            log.error("fail to send wx notify", e);
        }
    }

    public static void sendMessage(String content, Throwable exception, MsgType weChatURL) {
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            WeixinMessage message = new WeixinMessage();
            message.setContent(stringWriter.toString());
            arrangeMessage(weChatURL, message);
        } catch (Exception e) {
            log.error("fail to send wx notify", e);
        }
    }


}
