package com.edgec.browserbackend.wxpay;

import java.io.InputStream;

public class FGLWxConfig extends WXPayConfig {
    @Override
    public String getAppID() {
        return "wx5a3621300bfec508";
    }

    @Override
    public String getMchID() {
        return "1553406861";
    }

    @Override
    public String getKey() {
        return "acdkgjef237ckgSriEICRe2408sdjEDC";
    }

    public int getHttpConnectTimeoutMs() {
        return 8000;
    }

    public int getHttpReadTimeoutMs() {
        return 10000;
    }

    @Override
    public InputStream getCertStream() {
        return getClass().getResourceAsStream("/certs/fangguanlian_cert.p12");
    }

    @Override
    public IWXPayDomain getWXPayDomain() {
        IWXPayDomain iwxPayDomain = new IWXPayDomain() {

            public void report(String domain, long elapsedTimeMillis, Exception ex) {

            }

            public DomainInfo getDomain(WXPayConfig config) {
                return new IWXPayDomain.DomainInfo(WXPayConstants.DOMAIN_API, true);
            }
        };
        return iwxPayDomain;

    }

    @Override
    public String getBody() {
        return "深圳云穹科技-用户充值";
    }

    @Override
    public String getWebUrl() {
        return "https://www.fangguanlian.cn/home/";
    }

}
