package com.edgec.browserbackend.account.domain;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Email;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Data
public class User {

    @Length(min = 3, max = 20, message = "Name length should be between 3 - 20")
    private String username;

    @Length(min = 6, max = 40, message = "Password length should be between 6 - 40")
    private String password;

    @Email(message = "Invalid email address")
    private String email;

    private String phone;

    private String authCode;

    private String promotionCode;

    private boolean enabled = false;

    private String lockReason;

    private boolean allowedToCreateSubUser = true;

    private int permission;

    private List<String> whiteList = new ArrayList<>();

    private String verificationCode = UUID.randomUUID().toString();

}
