package com.edgec.browserbackend.account.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;
import java.util.List;

@Document(collection = "userlackmoney")
@JsonIgnoreProperties(ignoreUnknown = true)
public class UserLackMoney {

    @Id
    private String username;

    private float lackMoney;//缺多少钱

    private List<String> billIds;

    private int billsNum;

    private Date updateDate;

    public UserLackMoney() {
    }

    public UserLackMoney(String username, float lackMoney, List<String> billIds, int billsNum, Date updateDate) {
        this.username = username;
        this.lackMoney = lackMoney;
        this.billIds = billIds;
        this.billsNum = billsNum;
        this.updateDate = updateDate;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public float getLackMoney() {
        return lackMoney;
    }

    public void setLackMoney(float lackMoney) {
        this.lackMoney = lackMoney;
    }

    public List<String> getBillIds() {
        return billIds;
    }

    public void setBillIds(List<String> billIds) {
        this.billIds = billIds;
    }

    public int getBillsNum() {
        return billsNum;
    }

    public void setBillsNum(int billsNum) {
        this.billsNum = billsNum;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
}
