package com.edgec.browserbackend.account.repository;

import com.edgec.browserbackend.account.domain.RealnameAuthRecord;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RealnameAuthRecordRepository extends MongoRepository<RealnameAuthRecord, String>, RealnameAuthRecordRepositoryCustom {

    List<RealnameAuthRecord> findByUsernameAndAuthTimeGreaterThanEqual(String username, long authTime);

    RealnameAuthRecord findByUsernameAndIsSuccess(String username, boolean isSuccess);

    RealnameAuthRecord findByShortUrlAndUsername(String shortUrl, String username);

    RealnameAuthRecord findByShortUrlAndAuthTimeGreaterThanEqual(String shortUrl, long time);

    RealnameAuthRecord findByUsernameAndCertNameAndCertNoAndIsSuccessAndAuthTimeGreaterThanEqual(String username, String certName, String certNo, boolean isUsed, long time);

}
