package com.edgec.browserbackend.account.repository;

import com.edgec.browserbackend.account.domain.UserRate;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface UserRateRepository extends MongoRepository<UserRate, String> {

   List<UserRate> findByUsernameAndChargeType(String username, int chargeType);

   List<UserRate> findByUsername(String username);

   Page<UserRate> findAll(Pageable pageable);

   UserRate findByUsernameAndChargeTypeAndRegion(String username, int chargeType, String region);

}
