package com.edgec.browserbackend.browser.ErrorCode;

import com.edgec.browserbackend.common.commons.error.ErrorCode;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @author xuxin
 * @date 2020/8/13 17:19
 * @description
 */
public enum VpsErrorCode implements ErrorCode {

    /**
     * 未知错误
     */
    UNKNOWN(ErrorCode.COMMON_UNKNOWN, "unknown"),

    /**
     * vps不存在
     */
    VPS_NOT_EXIST(VPS_BASE + 201, "The VPS do not exist"),

    /**
     * 不具备分配权限
     */
    VPS_NOT_ACCESS(VPS_BASE + 202, "The user do not has access to assign vps");


    private final int code;
    private final String reason;

    VpsErrorCode(int value, String reasonPhrase) {
        this.code = value;
        this.reason = reasonPhrase;
    }

    @Override
    public int value() {
        return this.code;
    }

    @JsonValue
    @Override
    public int getCode() {
        return code;
    }

    @Override
    public String toString() {
        return Integer.toString(this.code);
    }

    @Override
    public String getReason() {
        return reason;
    }
}
