package com.edgec.browserbackend.browser.controller;

import com.alibaba.fastjson.JSONObject;
import com.edgec.browserbackend.account.dto.ResultDto;
import com.edgec.browserbackend.browser.dto.IpListRequestDto;
import com.edgec.browserbackend.browser.dto.IpPageResultDto;
import com.edgec.browserbackend.browser.dto.IpResourceRequestDto;
import com.edgec.browserbackend.browser.dto.IpResourceUpdateDto;
import com.edgec.browserbackend.browser.service.Impl.IpResourceServiceImpl;
import com.edgec.browserbackend.browser.service.IpResourceService;
import com.edgec.browserbackend.common.auth.Securitys;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/ip")
public class IpControlloer {

    @Autowired
    private IpResourceService ipResourceService;

    private final Logger log = LoggerFactory.getLogger(IpResourceServiceImpl.class);

    /**
     * 购买IP资源
     *
     * @param principal principal
     * @param ipResourceRequestDto todo
     * @return ResultDto
     */
    @RequestMapping(value = "/buy", method = RequestMethod.POST)
    public ResultDto buyIp(Principal principal, @RequestBody IpResourceRequestDto ipResourceRequestDto) {
        ResultDto resultDto = new ResultDto();
        String logs = "【buyIp】 ";
        log.info("{}, params : {}", logs, principal.getName());
        try {
            List<String> ipResourceDto = ipResourceService.buyIp(principal.getName(), ipResourceRequestDto);
            resultDto.setData(ipResourceDto);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    /**
     * 续费IP资源
     *
     * @param principal principal
     * @param ipResourceRequestDto todo
     * @return ResultDto
     */
    @RequestMapping(value = "/renew", method = RequestMethod.POST)
    public ResultDto renewIp(Principal principal, @RequestBody IpResourceRequestDto ipResourceRequestDto) {
        ResultDto resultDto = new ResultDto();
        String logs = "【renewIp】 ";
        log.info("{}, params : {}", logs, principal.getName());
        try {
            resultDto.setData(ipResourceService.renewIp(principal.getName(), ipResourceRequestDto));
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    /**
     * 删除指定IP资源
     *
     * @param principal principal
     * @param ipResourceRequestDto todo
     * @return ResultDto
     */
    @RequestMapping(value = "/del", method = RequestMethod.POST)
    public ResultDto deleteIp(Principal principal, @RequestBody IpResourceRequestDto ipResourceRequestDto) {
        ResultDto resultDto = new ResultDto();
        String logs = "【deleteIp】 ";
        log.info("{}, params : {}", logs, principal.getName());
        try {
            resultDto.setData(ipResourceService.deleteIp(principal.getName(), ipResourceRequestDto));
            resultDto.setStatus(0);
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    /**
     * 获取IP列表
     *
     * @param principal principal
     * @param ipListRequestDto todo
     * @return ResultDto
     */
    @RequestMapping(value = "/list", method = RequestMethod.POST)
    public ResultDto getIpList(Principal principal, @RequestBody IpListRequestDto ipListRequestDto) {
        ResultDto resultDto = new ResultDto();
        String logs = "【getIpList】 ";
        log.info("{}, params : {}", logs, principal.getName());
        try {
            IpPageResultDto ipResourceDto = ipResourceService.getIpList(principal.getName(), ipListRequestDto.getGroupType(), ipListRequestDto.getPage(),
                    ipListRequestDto.getAmount(), ipListRequestDto.getFilter());
            resultDto.setData(ipResourceDto);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    /**
     * （暂不知）
     *
     * @param principal principal
     * @param ipResourceUpdateDto todo
     * @return ResultDto
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResultDto updateIp(Principal principal, @RequestBody IpResourceUpdateDto ipResourceUpdateDto) {
        ResultDto resultDto = new ResultDto();
        String logs = "【updateIp】 ";
        log.info("{}, params : {}", logs, principal.getName());
        try {
            ipResourceService.updateIp(principal.getName(), ipResourceUpdateDto);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode().getCode());
            statusInfo.put("message", e.getErrorCode().getReason());
            resultDto.setStatusInfo(statusInfo);
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    /**
     * 获取IP信息
     *
     * @param principal principal
     * @param ipResourceUpdateDto todo
     * @return ResultDto
     */
    @RequestMapping(value = "/query", method = RequestMethod.POST)
    public ResultDto queryIp(Principal principal, @RequestBody IpResourceUpdateDto ipResourceUpdateDto) {
        ResultDto resultDto = new ResultDto();
        String logs = "【queryIp】 ";
        log.info("{}, params : {}", logs, principal.getName());
        try {
            HashMap<String, Boolean> map = new HashMap<>();
            map.put("found", ipResourceService.queryIpExist(principal.getName(), ipResourceUpdateDto));
            resultDto.setData(map);
            resultDto.setStatus(0);
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    /**
     *
     *
     * @param principal principal
     * @param ipResourceRequestDto todo
     * @return ResultDto
     */
    @RequestMapping(value = "/detail", method = RequestMethod.POST)
    public ResultDto queryIpDetail(Principal principal, @RequestBody IpResourceRequestDto ipResourceRequestDto) {
        ResultDto resultDto = new ResultDto();
        String logs = "【queryIpDetail】 ";
        log.info("{}, params : {}", logs, principal.getName());
        try {
            resultDto.setData(ipResourceService.queryIp(principal.getName(), ipResourceRequestDto));
            resultDto.setStatus(0);
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    /**
     *
     *
     * @param principal principal
     * @return ResultDto
     */
    @RequestMapping(value = "/special/set", method = RequestMethod.PUT)
    public ResultDto setSpecialLine(Principal principal) {
        ResultDto resultDto = new ResultDto();
        String logs = "【setSpecialLine】 ";
        log.info("{}, params : {}", logs, principal.getName());
        try {
            ipResourceService.setSpecialLine();
            resultDto.setStatus(0);
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    /**
     *
     *
     * @param principal principal
     * @return ResultDto
     */
    @RequestMapping(value = "/releasedeleted", method = RequestMethod.PUT)
    public ResultDto deleteUseless(Principal principal) {
        ResultDto resultDto = new ResultDto();
        String logs = "【deleteUseless】 ";
        log.info("{}, params : {}", logs, principal.getName());
        try {
            ipResourceService.releaseDeletedIp();
            resultDto.setStatus(0);
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    /**
     *
     *
     * @param principal principal
     * @return ResultDto
     */
    @RequestMapping(value = "/transferbindshops", method = RequestMethod.PUT)
    @PreAuthorize(Securitys.ADMIN_EL)
    public ResultDto transferBindShops(Principal principal) {
        ResultDto resultDto = new ResultDto();
        String logs = "【transferBindShops】 ";
        log.info("{}, params : {}", logs, principal.getName());
        try {
            ipResourceService.transferBindShops();
            resultDto.setStatus(0);
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }
}
