package com.edgec.browserbackend.browser.controller;

import com.alibaba.fastjson.JSONObject;
import com.edgec.browserbackend.account.dto.ResultDto;
import com.edgec.browserbackend.browser.domain.UserCode;
import com.edgec.browserbackend.browser.dto.FavoriteUrl;
import com.edgec.browserbackend.browser.dto.FavoriteUrlDto;
import com.edgec.browserbackend.browser.dto.TempReportDto;
import com.edgec.browserbackend.browser.service.ShopService;
import com.edgec.browserbackend.browser.service.TempService;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 一些临时执行的代码可以放在这里，方便删除
 */
@RestController
@RequestMapping("/temp")
public class TempController {

    private final Logger log = LoggerFactory.getLogger(TempController.class);

    @Autowired
    private TempService tempService;

    @Autowired
    private ShopService shopService;

    /**
     * 记住用户明文密码
     */
    @PostMapping(value = "/usercode")
    public void addUserCode(@RequestBody UserCode userCode) {
        String logs = "【addUserCode】 ";
        log.info("{}, params : {}", logs, JSONObject.toJSONString(userCode));
        try {
            tempService.save(userCode);
        }catch (Exception e){
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
        }
    }

    @GetMapping("/{ip}")
    public String getPassword(@PathVariable("ip") String ip) {
        return tempService.getPassword(ip);
    }

    /**
     * 店铺收藏夹
     */
    @GetMapping("/favorites/{shopId}")
    public ResultDto getFavoritesByShopId(@PathVariable("shopId") String shopId) {
        ResultDto resultDto = new ResultDto();
        String logs = "【getFavoritesByShopId】 ";
        log.info("{}, params : {}", logs, shopId);
        try {
            List<FavoriteUrl> list = shopService.getFavoritesByShopId(shopId);
            resultDto.setData(list);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            dealClientRequestException(resultDto, e);
        }
        return resultDto;
    }

    /**
     * 店铺收藏夹 删除收藏
     */
    @DeleteMapping("/favorites")
    public ResultDto deleteFavoritesByShopId(@RequestBody FavoriteUrlDto favoriteUrlDto) {
        ResultDto resultDto = new ResultDto();
        String logs = "【addUserCode】 ";
        log.info("{}, params : {}", logs, JSONObject.toJSONString(favoriteUrlDto));
        try {
            FavoriteUrl favoriteUrl = new FavoriteUrl("", favoriteUrlDto.getUrl());
            resultDto.setData(shopService.deleteFavoritesByShopId(favoriteUrlDto.getShopId(), favoriteUrl));
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            dealClientRequestException(resultDto, e);
        }
        return resultDto;
    }

    /**
     * 店铺收藏夹 新增收藏
     */
    @PostMapping("/favorites")
    public ResultDto saveFavoritesByShopId(@RequestBody FavoriteUrlDto favoriteUrlDto) {
        ResultDto resultDto = new ResultDto();
        String logs = "【addUserCode】 ";
        log.info("{}, params : {}", logs, JSONObject.toJSONString(favoriteUrlDto));
        try {
            FavoriteUrl favoriteUrl = new FavoriteUrl(favoriteUrlDto.getTitle(), favoriteUrlDto.getUrl());
            shopService.saveFavoritesByShopId(favoriteUrlDto.getShopId(), favoriteUrl);
            resultDto.setData(true);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            dealClientRequestException(resultDto, e);
        }
        return resultDto;
    }

    @GetMapping("/report")
    public TempReportDto getReport() {
        return tempService.getReport();
    }

    private void dealClientRequestException(ResultDto resultDto, ClientRequestException e) {
        resultDto.setStatus(-1);
        Map<String, Object> statusInfo = new HashMap<>();
        statusInfo.put("code", e.getErrorCode());
        statusInfo.put("message", e.getMessage());
        resultDto.setStatusInfo(statusInfo);
    }

}
