package com.edgec.browserbackend.browser.controller;

import com.alibaba.fastjson.JSONObject;
import com.edgec.browserbackend.account.dto.ResultDto;
import com.edgec.browserbackend.browser.domain.Vps;
import com.edgec.browserbackend.browser.dto.AssignVpsDto;
import com.edgec.browserbackend.browser.dto.PageInfo;
import com.edgec.browserbackend.browser.dto.VpsPageResultDto;
import com.edgec.browserbackend.browser.service.VpsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.security.Principal;
import java.util.List;

/**
 * @author xuxin
 * @date 2020/8/13 11:49
 * @description
 */
@RestController
@RequestMapping("/vps")
public class VpsController {

    private final Logger log = LoggerFactory.getLogger(VpsController.class);

    @Autowired
    private VpsService vpsService;

    @PostMapping("/add")
    public ResultDto addVps(Principal principal, @Validated @RequestBody Vps vps) {
        ResultDto resultDto = new ResultDto();
        String logs = "【addVps】 ";
        log.info("{}, params : {}, {}", logs, principal.getName(), JSONObject.toJSONString(vps));
        try {
            vps.setOwner1(principal.getName());
            String s = vpsService.addVps(vps);
            resultDto.setData(s);
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
        }
        return resultDto;
    }

    @DeleteMapping("/{id}")
    public ResultDto deleteVps(Principal principal, @PathVariable String id) {
        ResultDto resultDto = new ResultDto();
        String logs = "【deleteVps】 ";
        log.info("{}, params : {}, {}", logs, principal.getName(), id);
        try {
            vpsService.deleteVps(principal.getName(), id);
            resultDto.setStatus(0);
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
        }
        return resultDto;
    }

    @PutMapping("/update")
    public ResultDto updateVps(@RequestBody Vps vps) {
        ResultDto resultDto = new ResultDto();
        String logs = "【updateVps】 ";
        log.info("{}, params : {}", logs, JSONObject.toJSONString(vps));
        try {
            vpsService.updateVps(vps);
            resultDto.setStatus(0);
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
        }
        return resultDto;
    }

    /**
     * 登录
     */
    @GetMapping("/login_vps/{id}")
    public ResultDto getVps(@PathVariable String id) {
        ResultDto resultDto = new ResultDto();
        String logs = "【getVps】 ";
        log.info("{}, params : {}", logs, id);
        try {
            String rdp = vpsService.loginVps(id);
            resultDto.setStatus(0);
            resultDto.setData(rdp);
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
        }
        return resultDto;
    }

    /**
     * 列表
     */
    @GetMapping("/list")
    public ResultDto getVpsList(Principal principal, @RequestParam(value = "page") int page, @RequestParam(value = "size") int size) {
        ResultDto resultDto = new ResultDto();
        String logs = "【getVpsList】 ";
        log.info("{}, params : {}, {}, {}", logs, principal.getName(), page, size);
        try {
            Pageable pageable = PageRequest.of(page, size);
            Page<Vps> pageInfo = vpsService.queryPage(principal.getName(), pageable);
            resultDto.setData(pageInfo);

            /// 临时这样写，有空了得去掉下面三行
            PageInfo pageResult = new PageInfo(pageInfo.getPageable().getPageNumber(), pageInfo.getTotalPages(), (int) pageInfo.getTotalElements());
            VpsPageResultDto<Vps> shopPageResultDto = new VpsPageResultDto<>(pageInfo.getContent(), pageResult);
            resultDto.setData(shopPageResultDto);

            resultDto.setStatus(0);
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
        }
        return resultDto;
    }

    /**
     * 分配 vps 给子账户
     */
    @PostMapping("/assign")
    public ResultDto assignVpsList(Principal principal, @RequestBody AssignVpsDto assignVpsDto) {
        ResultDto resultDto = new ResultDto();
        String logs = "【assignVpsList】 ";
        log.info("{}, params : {}", logs, JSONObject.toJSONString(assignVpsDto));
        try {
            List<String> list = vpsService.assignVpsList(principal.getName(), assignVpsDto);
            if (list.isEmpty()) {
                resultDto.setStatus(0);
            } else {
                resultDto.setStatus(-1);
                resultDto.setData(list);
            }
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
        }
        return resultDto;
    }

    /**
     * 查看当前vps已经绑定的  子用户
     */
    @GetMapping("/list/{id}")
    public ResultDto getVpsList(Principal principal, @PathVariable String id) {
        ResultDto resultDto = new ResultDto();
        String logs = "【getVpsList】 ";
        log.info("{}, params : {}", logs, id);
        try {
            List<String> list = vpsService.queryAssignUserList(principal.getName(), id);
            resultDto.setData(list);
            resultDto.setStatus(0);
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
        }
        return resultDto;
    }


}
