package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.domain.BrowserWinLog;
import com.edgec.browserbackend.browser.domain.WinHistory;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

import java.time.Instant;
import java.time.temporal.ChronoUnit;

import static org.springframework.data.mongodb.core.query.Criteria.where;

/**
 * @author xuxin
 * @date 2020/9/4 15:56
 * @description
 */
public class BrowserWinLogRepositoryCustomImpl implements BrowserWinLogRepositoryCustom {
    @Autowired
    MongoTemplate mongoTemplate;

    @Override
    public void addWinLog(String username, WinHistory winHistory) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("_id").is(username));

        Update update = new Update();
        update.addToSet("list", winHistory);
        mongoTemplate.upsert(basicQuery, update, BrowserWinLog.class);
    }

    @Override
    public void deleteBeforeWinLog(String username, int daysBefore) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("_id").is(username));

        Update update = new Update();
        update.pull("list", Query.query(Criteria.where("time").lte(Instant.now().minus(daysBefore, ChronoUnit.DAYS).toEpochMilli())));
        mongoTemplate.upsert(basicQuery, update, BrowserWinLog.class);
    }
}
