package com.edgec.browserbackend.browser.task;

import com.edgec.browserbackend.account.domain.PaymentMethod;
import com.edgec.browserbackend.account.domain.UserPayment;
import com.edgec.browserbackend.account.repository.UserPaymentRepository;
import com.edgec.browserbackend.account.service.PaymentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;

@Component
public class PaymentTask {

    private static final Logger log = LoggerFactory.getLogger(PaymentTask.class);


    @Autowired
    private UserPaymentRepository userPaymentRepository;

    @Autowired
    private PaymentService paymentService;

    @Scheduled(fixedDelay = 60000)
    public void checkPayments() {
        long now = System.currentTimeMillis();
        Date date_5min = new Date(now - 5 * 60 * 1000);
        Date date_10min = new Date(now - 10 * 60 * 1000);
        // 查找 5-10 分钟内 支付状态为 false 的订单
        List<UserPayment> unfinishedPayments = userPaymentRepository.findAllByPaymentDateBetweenAndSucceed(
                ZonedDateTime.ofInstant(date_10min.toInstant(), ZoneId.systemDefault()),
                ZonedDateTime.ofInstant(date_5min.toInstant(), ZoneId.systemDefault()),
                false);

        if (unfinishedPayments != null && !unfinishedPayments.isEmpty()) {
            unfinishedPayments.forEach(
                    payment -> {
                        PaymentMethod paymentMethod = payment.getPaymentMethod();
                        try {
                            /*
                             * 自动调用 微信或者支付宝的支付接口来确认 支付状态
                             * chargeType 取值范围为 0-4
                             * 此处设置为 100 仅仅只是为了避免 wxCheckOrderStatus() 方法中  chargeType == 0  相关代码块
                             */
                            log.info("主动确认订单" + payment.getTradeNo() + "支付状态,此时chargeType为 100");
                            if (PaymentMethod.WECHAT.equals(paymentMethod)) {
                                paymentService.wxCheckOrderStatus(payment.getTradeNo(), 100);
                            }

                            if (PaymentMethod.ALIPAY.equals(paymentMethod)) {
                                paymentService.aliCheckOrderStatus(payment.getTradeNo(), 100);
                            }
                        } catch (Exception e) {
                            log.error("checkPayments", e);
                        }
                    }
            );
        }
    }
}