package com.edgec.browserbackend.common.commons.error;

import com.edgec.browserbackend.common.commons.core.ApplicationContextProvider;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;

import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class IntelligroupOauthExceptionSerializer extends StdSerializer<IntelligroupOauthException> {

    public IntelligroupOauthExceptionSerializer() {

        super(IntelligroupOauthException.class);
    }

    @Override
    public void serialize(IntelligroupOauthException value, JsonGenerator gen, SerializerProvider provider) throws IOException {
//        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();

        gen.writeStartObject();
        gen.writeStringField("timestamp", value.getTimestamp().format(DateTimeFormatter.ofPattern("dd-MM-yyyy hh:mm:ss")));

        MessageSource messageSource = ApplicationContextProvider.getBean(MessageSource.class);
        Locale locale = LocaleContextHolder.getLocale();
        String message = value.getMessage();
        try {
            message = messageSource.getMessage("" + value.getErrorCode(), null, locale);
        } catch (NoSuchMessageException e) {
        }

        gen.writeStringField("message", message);
        gen.writeStringField("debugMessage", value.getDebugMessage());
        gen.writeStringField("errorCode", "" + value.getErrorCode());

        gen.writeEndObject();
    }
}
