package com.edgec.browserbackend.common.commons.utils;

import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class PriorityFutureTask<V>
        extends FutureTask<V> implements Comparable<PriorityFutureTask<V>> {

    private Object object;
    private Comparator comparator;


    public PriorityFutureTask(Callable<V> callable, Comparator comparator) {
        super(callable);
        this.object = callable;
        this.comparator = comparator;
    }

    public PriorityFutureTask(Runnable runnable, V result, Comparator comparator) {
        super(runnable, result);
        this.object = runnable;
        this.comparator = comparator;
    }

    @Override
    public int compareTo(PriorityFutureTask<V> o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return -1; // high priority
        }
        if (object != null && o.object != null) {
            return this.comparator.compare(this.object, o.object);
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        } else if (!(obj instanceof PriorityFutureTask)) {
            return false;
        } else {
            PriorityFutureTask<V> c = (PriorityFutureTask<V>) obj;
            return object.equals(c.object);
        }
    }

    @Override
    public int hashCode() {
        return object.hashCode();
    }

    public Object getObject() {
        return object;
    }

    public void setObject(Object object) {
        this.object = object;
    }
}
