package com.edgec.browserbackend.wxpay;

import java.io.InputStream;

public class CloudamWxConfig extends WXPayConfig {

    @Override
    public String getAppID() {
        return "wx5a3621300bfec508";
    }

    @Override
    public String getMchID() {
        return "1535208831";
    }

    @Override
    public String getKey() {
        return "acdkgjef237ckgSriEICRe2408sdjSKJ";
    }

    public int getHttpConnectTimeoutMs() {
        return 8000;
    }

    public int getHttpReadTimeoutMs() {
        return 10000;
    }

    @Override
    public InputStream getCertStream() {
        return getClass().getResourceAsStream("/certs/wx_cert.p12");
    }

    @Override
    public IWXPayDomain getWXPayDomain() {
        IWXPayDomain iwxPayDomain = new IWXPayDomain() {

            public void report(String domain, long elapsedTimeMillis, Exception ex) {

            }

            public DomainInfo getDomain(WXPayConfig config) {
                return new IWXPayDomain.DomainInfo(WXPayConstants.DOMAIN_API, true);
            }
        };
        return iwxPayDomain;

    }

    @Override
    public String getBody() {
        return "Cloudam深圳云端软件-用户充值";
    }

    @Override
    public String getWebUrl() {
        return "https://www.cloudam.cn/";
    }
}
