package com.edgec.browserbackend.account.service;

import com.edgec.browserbackend.account.domain.*;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

public interface AdministratorService {

    Administrator createAdministrator(Administrator administrator);

    Administrator updateAdministrator(String name, String string);

    List<Administrator> getAllAdministrator();

    void deleteAdministrator(String name);

    Account getAccountByName(String target);

    Account getAccountByPhoneNumber(String target);

    Account getAccountByEmail(String target);

    List<UserPrePaidBilling> getUserBillingByName(String name);

    Account unLockLockedAccount(String name, Account account);

    Account lockAbnormalAccount(String name, Account account);

    Page<Account> searchAllUserPage(Pageable pageable);

    Page<UserPrePaidBilling> searchAllUserBillingPage(int page, int year1, int month1, int year2, int month2);

    Page<Account> searchCreateAccountBetween(Pageable pageable, String strDate1, String strDate2);

    List<UserPrePaidBilling> getServiceFeeOwedUserInfo();

    List<CompanyEarningsDto> getCompanyEarningDetail(String stringdate);

    boolean getUserLockState(String name);

    void deleteUser(String username);

    UserBalance findUserBalance(String username);

    //迁移userbilling到userprepaidbilling
    boolean userbillingTransfer();

}
