package com.edgec.browserbackend.account.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.response.AlipayTradePagePayResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.edgec.browserbackend.account.exception.AccountErrorCode;
import com.edgec.browserbackend.account.repository.UserBalanceRepository;
import com.edgec.browserbackend.account.repository.UserPaymentRepository;
import com.edgec.browserbackend.account.repository.UserPrePaidBillingRepository;
import com.edgec.browserbackend.account.service.AccountService;
import com.edgec.browserbackend.account.service.PaymentService;
import com.edgec.browserbackend.account.controller.AccountController;
import com.edgec.browserbackend.account.domain.*;
import com.edgec.browserbackend.account.service.SmsUtils;
import com.edgec.browserbackend.account.service.UserPrePaidBillingService;
import com.edgec.browserbackend.alipay.AlipayConfig;
import com.edgec.browserbackend.alipay.CloudamAlipayConfig;
import com.edgec.browserbackend.alipay.VpsAlipayConfig;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import com.edgec.browserbackend.wxpay.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.stereotype.Service;

import java.time.Instant;
import java.time.YearMonth;
import java.util.HashMap;
import java.util.Map;

@Service
public class PaymentServiceImpl implements PaymentService {

    private final Logger log = LoggerFactory.getLogger(getClass());

    @Autowired
    private UserPaymentRepository userPaymentRepository;

    @Autowired
    private UserBalanceRepository userBalanceRepository;

    @Autowired
    private AccountService accountService;

    @Autowired
    private UserPrePaidBillingRepository userPrePaidBillingRepository;

    @Override
    public String wechatPayCallback(String tradno) {

        UserPayment byTradeNo = userPaymentRepository.findByTradeNo(tradno);

        if (byTradeNo != null && !byTradeNo.isSucceed()) {
            wxCheckOrderStatus(byTradeNo.getTradeNo(), 0);
        }
        return "<xml>\n" +
                "\n" +
                "  <return_code><![CDATA[SUCCESS]]></return_code>\n" +
                "  <return_msg><![CDATA[OK]]></return_msg>\n" +
                "</xml>";
    }

    @Override
    public void alipaCallback(String tradno) {
        UserPayment byTradeNo = userPaymentRepository.findByTradeNo(tradno);

        if (byTradeNo != null && !byTradeNo.isSucceed()) {
            aliCheckOrderStatus(byTradeNo.getTradeNo(), 0);
        }
    }

    @Override
    public UserPaymentDto wxCheckOrderStatus(String tradeno, int more) {

        UserPaymentDto result = new UserPaymentDto();
        result.setPaid(false);
        try {

            UserPayment byTradeNo = userPaymentRepository.findByTradeNo(tradeno);

            if (PaymentMethod.ALIPAY.equals(byTradeNo.getPaymentMethod()))
                return aliCheckOrderStatus(tradeno, more);

            UserBalance balance = userBalanceRepository.findById(byTradeNo.getUsername()).orElse(null);

            if (balance != null)
                result.setBalance(Math.round(balance.getBalanced()));

            if (byTradeNo == null)
                return result;
            if (byTradeNo.isSucceed()) {
                result.setPaid(true);
                return result;
            }

            Account byName = accountService.findByName(byTradeNo.getUsername());
            if (byName == null)
                throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST, "account does not exist: " + byTradeNo.getUsername());

            boolean isVpsClient = true;

            WXPayConfig ourWxPayConfig = isVpsClient ? new FGLWxConfig() : new CloudamWxConfig();
            WXPay wxPay = new WXPay(ourWxPayConfig);

            Map<String, String> data = new HashMap<>();
            data.put("appid", ourWxPayConfig.getAppID());
            data.put("mch_id", ourWxPayConfig.getMchID());         //商户号
            data.put("out_trade_no", tradeno);   //交易号
            data.put("nonce_str", SmsUtils.createRandom(false, 24));   // 随机字符串小于32位
            String s = WXPayUtil.generateSignature(data, ourWxPayConfig.getKey());  //签名
            data.put("sign", s);

            Map<String, String> respData = wxPay.orderQuery(data);

            if (respData.get("return_code").equals("SUCCESS") && respData.get("return_msg").equals("OK") && "SUCCESS".equals(respData.get("result_code"))) {

                /**
                 *
                 SUCCESS—支付成功

                 REFUND—转入退款

                 NOTPAY—未支付

                 CLOSED—已关闭

                 REVOKED—已撤销（付款码支付）

                 USERPAYING--用户支付中（付款码支付）

                 PAYERROR--支付失败(其他原因，如银行返回失败)                 *
                 */
                result.setStatus(respData.get("trade_state"));
                if ("SUCCESS".equals(respData.get("trade_state"))) {
                    byTradeNo.setSucceed(true);

                    boolean b = userPaymentRepository.updatePaymentResult(byTradeNo, true);

                    if (b) {
                        if (balance == null) {
                            balance = new UserBalance();
                            balance.setUsername(byTradeNo.getUsername());
                        }

                        UserPrePaidBilling bill = new UserPrePaidBilling();
                        bill.setChargeType(0);
                        bill.setAmount(0);
                        bill.setUnit(null);
                        bill.setPeriod(0);
                        bill.setPayMethod(2);
                        bill.setUsername(byTradeNo.getUsername());
                        bill.setTotal((float) byTradeNo.getAmount());
                        bill.setStatus(BillStatus.PAID);
                        bill.setPrepaid(true);
                        bill.setTimestamp(Instant.now().toEpochMilli());


                        final YearMonth lastmonth = YearMonth.now();

                        int monthValue = lastmonth.getMonthValue();
                        int year = lastmonth.getYear();
                        bill.setYear(year);
                        bill.setMonth(monthValue);

                        userPrePaidBillingRepository.save(bill);

                        if (more != 20 && more != 45 && more != 125 && more != 300)
                            more = 0;
                        if ((more == 20 && byTradeNo.getAmount() != 100) || (more != 20 && byTradeNo.getAmount() == 100))
                            more = 0;
                        if ((more == 45 && byTradeNo.getAmount() != 200) || (more != 45 && byTradeNo.getAmount() == 200))
                            more = 0;
                        if ((more == 125 && byTradeNo.getAmount() != 500) || (more != 125 && byTradeNo.getAmount() == 500))
                            more = 0;
                        if ((more == 300 && byTradeNo.getAmount() != 1000) || (more != 300 && byTradeNo.getAmount() == 1000))
                            more = 0;

                        balance.setBalanced(balance.getBalanced() + byTradeNo.getAmount() + more);
                        userBalanceRepository.save(balance);
                    }

                    result.setBalance(Math.round(balance.getBalanced()));
                    result.setPaid(true);
                    return result;
                }
            }
            result.setPaid(false);
        } catch (Exception e) {
            log.error("Wechat payment order generation fails", e);
            result.setPaid(false);
        }
        return result;
    }

    private String convertAlipayStatus(String src) {
        switch (src) {
            case "WAIT_BUYER_PAY":
                return "USERPAYING";
            case "TRADE_CLOSED":
                return "CLOSED";
            case "TRADE_SUCCESS":
                return "SUCCESS";
            case "TRADE_FINISHED":
                return "SUCCESS";
        }
        return src;
    }

    @Override
    public UserPaymentDto aliCheckOrderStatus(String tradno, int more) {
        UserPaymentDto result = new UserPaymentDto();
        result.setPaid(false);
        try {

            UserPayment byTradeNo = userPaymentRepository.findByTradeNo(tradno);
            UserBalance balance = userBalanceRepository.findById(byTradeNo.getUsername()).orElse(null);

            if (balance != null)
                result.setBalance(Math.round(balance.getBalanced()));

            if (byTradeNo == null)
                return result;
            if (byTradeNo.isSucceed()) {
                result.setPaid(true);
                return result;
            }

            Account byName = accountService.findByName(byTradeNo.getUsername());
            if (byName == null)
                throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST, "account does not exist: " + byTradeNo.getUsername());

            boolean isVpsClient = true;

            AlipayConfig alipayConfig = isVpsClient ? new VpsAlipayConfig() : new CloudamAlipayConfig();
            AlipayClient alipayClient = new DefaultAlipayClient(alipayConfig.getURL(), alipayConfig.getAPPID(), alipayConfig.getAPP_PRIVATE_KEY(),
                    "json", alipayConfig.getCHARSET(), alipayConfig.getALIPAY_PUBLIC_KEY(), alipayConfig.getSIGN_TYPE());

            AlipayTradeQueryRequest alipayRequest = new AlipayTradeQueryRequest();

            String out_trade_no = byTradeNo.getTradeNo();
            alipayRequest.setBizContent(""
                    + "{"
                    + "\"out_trade_no\":\"" + out_trade_no + "\""
                    + "}"
            );
            AlipayTradeQueryResponse response = alipayClient.execute(alipayRequest);
            log.error("ali order status :" + JSONObject.toJSONString(response));
            result.setStatus(convertAlipayStatus(response.getTradeStatus()));

            if ("TRADE_SUCCESS".equals(response.getTradeStatus()) || "TRADE_FINISHED".equals(response.getTradeStatus())) {
                byTradeNo.setSucceed(true);
                boolean b = userPaymentRepository.updatePaymentResult(byTradeNo, true);

                if (b) {
                    if (balance == null) {
                        balance = new UserBalance();
                        balance.setUsername(byTradeNo.getUsername());
                    }

                    UserPrePaidBilling bill = new UserPrePaidBilling();
                    bill.setChargeType(0);
                    bill.setAmount(0);
                    bill.setUnit(null);
                    bill.setPeriod(0);
                    bill.setPayMethod(1);
                    bill.setUsername(byTradeNo.getUsername());
                    bill.setTotal((float) byTradeNo.getAmount());
                    bill.setStatus(BillStatus.PAID);
                    bill.setPrepaid(true);
                    bill.setTimestamp(Instant.now().toEpochMilli());


                    final YearMonth lastmonth = YearMonth.now();

                    int monthValue = lastmonth.getMonthValue();
                    int year = lastmonth.getYear();
                    bill.setYear(year);
                    bill.setMonth(monthValue);


                    if (more != 20 && more != 45 && more != 125 && more != 300)
                        more = 0;
                    if ((more == 20 && byTradeNo.getAmount() != 100) || (more != 20 && byTradeNo.getAmount() == 100))
                        more = 0;
                    if ((more == 45 && byTradeNo.getAmount() != 200) || (more != 45 && byTradeNo.getAmount() == 200))
                        more = 0;
                    if ((more == 125 && byTradeNo.getAmount() != 500) || (more != 125 && byTradeNo.getAmount() == 500))
                        more = 0;
                    if ((more == 300 && byTradeNo.getAmount() != 1000) || (more != 300 && byTradeNo.getAmount() == 1000))
                        more = 0;

                    balance.setBalanced(balance.getBalanced() + byTradeNo.getAmount() + more);
                    userBalanceRepository.save(balance);
                }

                result.setBalance(Math.round(balance.getBalanced()));
                result.setPaid(true);
                return result;
            }

            result.setPaid(false);
        } catch (Exception e) {
            log.error("Alipay payment order generation fails", e);
            result.setPaid(false);
        }
        return result;
    }

    @Override
    public String alipayPutPayOrder(String username, int amount, String by) {

        Account byName = accountService.findByName(username);
        if (byName == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST, "account does not exist: " + username);

        boolean isVpsClient = true;

        UserPayment internalOrder = new UserPayment();
        internalOrder.setAmount(amount);
        internalOrder.setPaymentMethod(PaymentMethod.ALIPAY);
        internalOrder.setSucceed(false);
        internalOrder.setUsername(username);

        try {

            AlipayConfig alipayConfig = isVpsClient ? new VpsAlipayConfig() : new CloudamAlipayConfig();
            AlipayClient alipayClient = new DefaultAlipayClient(alipayConfig.getURL(), alipayConfig.getAPPID(), alipayConfig.getAPP_PRIVATE_KEY(),
                    "json", alipayConfig.getCHARSET(), alipayConfig.getALIPAY_PUBLIC_KEY(), alipayConfig.getSIGN_TYPE());

            AlipayTradePagePayRequest alipayRequest = new AlipayTradePagePayRequest();
            alipayRequest.setReturnUrl(alipayConfig.getReturnUrl(isVpsClient, by) + internalOrder.getTradeNo());
            alipayRequest.setNotifyUrl(alipayConfig.getNOTIFY_URL() + internalOrder.getTradeNo());

            String out_trade_no = internalOrder.getTradeNo();
            String product_code = "FAST_INSTANT_TRADE_PAY";
            String total_amount = "" + amount + ".00";
            String subject = "订单" + out_trade_no;
            String body = "";

            alipayRequest.setBizContent(""
                    + "{"
                    + "\"out_trade_no\":\"" + out_trade_no + "\","
                    + "\"product_code\":\"" + product_code + "\","
                    + "\"total_amount\":\"" + total_amount + "\","
                    + "\"subject\":\"" + subject + "\","
                    + "\"body\":\"" + body + "\""
                    + "}"
            );
            AlipayTradePagePayResponse response = alipayClient.pageExecute(alipayRequest);
            internalOrder.setTransId(response.getTradeNo());
            userPaymentRepository.save(internalOrder);

            String form = response.getBody();
            return form;

        } catch (Exception e) {
            log.error("Alypay payment order generation fails", e);
            throw new ClientRequestException(AccountErrorCode.ALIPAYERROR, "Alypay payment order error");
        }
    }

    @Override
    public UserPaymentDto wxPutPayOrder(String username, int amount) {

        Account byName = accountService.findByName(username);
        if (byName == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST, "account does not exist: " + username);

        boolean isVpsClient = true;

        UserPayment internalOrder = new UserPayment();
        internalOrder.setAmount(amount);
        internalOrder.setPaymentMethod(PaymentMethod.WECHAT);
        internalOrder.setSucceed(false);
        internalOrder.setUsername(username);

        try {

            String notifyUrl = AccountController.WECHAT_PAY_CALLBACK_URL + internalOrder.getTradeNo();

            WXPayConfig ourWxPayConfig = isVpsClient ? new FGLWxConfig() : new CloudamWxConfig();
            WXPay wxPay = new WXPay(ourWxPayConfig);

            Map<String, String> data = new HashMap<>();
            data.put("appid", ourWxPayConfig.getAppID());
            data.put("mch_id", ourWxPayConfig.getMchID());         //商户号
            data.put("body", ourWxPayConfig.getBody());
            data.put("trade_type", "NATIVE");                         //NATIVE 扫码支付
            data.put("notify_url", notifyUrl);                     //回调地址
            data.put("spbill_create_ip", "127.0.0.1");             //终端ip
            data.put("total_fee", "" + amount * 100);       //订单总金额
            data.put("fee_type", "CNY");                           //默认人民币
            data.put("out_trade_no", internalOrder.getTradeNo());   //交易号
            data.put("nonce_str", internalOrder.getTradeNo());   // 随机字符串小于32位
            String s = WXPayUtil.generateSignature(data, ourWxPayConfig.getKey());  //签名
            data.put("sign", s);

            Map<String, String> respData = wxPay.unifiedOrder(data);
            if (respData.get("return_code").equals("SUCCESS") && respData.get("result_code").equals("SUCCESS")) {
                userPaymentRepository.save(internalOrder);
                UserPaymentDto result = new UserPaymentDto();
                result.setTradeNo(internalOrder.getTradeNo());
                result.setUrl(respData.get("code_url"));
                return result;
            } else {
                log.error("Fail to create ex order : " + JSONObject.toJSONString(respData));
                throw new ClientRequestException(AccountErrorCode.WECHATERROR, "Wechat payment order error");
            }
        } catch (Exception e) {
            log.error("Wechat payment order generation fails", e);
            throw new ClientRequestException(AccountErrorCode.WECHATERROR, "Wechat payment order error");
        }
    }

    @Override
    public UserBalance bankTransferInsertion(String username, int amount) {

        UserPayment bankOrder = new UserPayment();
        bankOrder.setUsername(username);
        bankOrder.setAmount(amount);
        bankOrder.setPaymentMethod(PaymentMethod.BANK);
        bankOrder.setSucceed(true);
        userPaymentRepository.save(bankOrder);

        UserBalance userBalance = userBalanceRepository.findById(username).orElse(null);
        if (userBalance == null) {
            userBalance = new UserBalance();
            userBalance.setUsername(username);
            userBalance.setUsed(0);
            userBalance.setBalanced(amount);
            return userBalanceRepository.save(userBalance);
        } else {
            userBalanceRepository.incrementBalance(userBalance, amount, 0);
        }
        return userBalanceRepository.findById(username).orElse(null);
    }


    @Override
    public UserPaymentDto h5wxPayOrder(String ip, String username, int amount) {

        Account byName = accountService.findByName(username);
        if (byName == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST, "account does not exist: " + username);

        boolean isVpsClient = true;

        UserPayment internalOrder = new UserPayment();
        internalOrder.setAmount(amount);
        internalOrder.setPaymentMethod(PaymentMethod.WECHAT);
        internalOrder.setSucceed(false);
        internalOrder.setUsername(username);

        try {
            String notifyUrl = AccountController.WECHAT_PAY_CALLBACK_URL + internalOrder.getTradeNo();
//            String redirectUrl = "https://www.cloudam.cn";
//            String redirectUrlEncode = URLEncoder.encode(redirectUrl, "utf-8");

            WXPayConfig ourWxPayConfig = isVpsClient ? new FGLWxConfig() : new CloudamWxConfig();
            WXPay wxPay = new WXPay(ourWxPayConfig);

            Map<String, String> data = new HashMap<>();
            data.put("appid", ourWxPayConfig.getAppID());
            data.put("mch_id", ourWxPayConfig.getMchID());         //商户号
            data.put("body", ourWxPayConfig.getBody());
            data.put("trade_type", "MWEB");
            data.put("notify_url", notifyUrl);                     //回调地址
            data.put("spbill_create_ip", ip);             //终端ip
            data.put("total_fee", "" + amount * 100);       //订单总金额
            data.put("fee_type", "CNY");                           //默认人民币
            data.put("out_trade_no", internalOrder.getTradeNo());   //交易号
            data.put("nonce_str", internalOrder.getTradeNo());   // 随机字符串小于32位

            JSONObject h5info = new JSONObject();
            h5info.put("type", "wap");
            h5info.put("wap_url", ourWxPayConfig.getWebUrl());
            h5info.put("wap_name", ourWxPayConfig.getBody());
            JSONObject scene_info = new JSONObject();
            scene_info.put("h5_info", h5info);
            data.put("scene_info", scene_info.toJSONString());
            String s = WXPayUtil.generateSignature(data, ourWxPayConfig.getKey());  //签名
            data.put("sign", s);

            Map<String, String> respData = wxPay.unifiedOrder(data);
            if (respData.get("return_code").equals("SUCCESS") && respData.get("result_code").equals("SUCCESS")) {
                userPaymentRepository.save(internalOrder);
                UserPaymentDto result = new UserPaymentDto();
                result.setTradeNo(internalOrder.getTradeNo());
                result.setUrl(respData.get("mweb_url"));
                return result;
            } else
                throw new ClientRequestException(AccountErrorCode.WECHATERROR, "Wechat payment order error");
        } catch (Exception e) {
            log.error("Wechat payment order generation fails", e);
            throw new ClientRequestException(AccountErrorCode.WECHATERROR, "Wechat payment order error");
        }
    }

}
