package com.edgec.browserbackend.auth.controller;

import com.edgec.browserbackend.auth.domain.User;
import com.edgec.browserbackend.auth.domain.UserPasswordReset;
import com.edgec.browserbackend.auth.service.UserAuthService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.token.TokenService;
import org.springframework.security.oauth2.provider.token.ConsumerTokenServices;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.security.Principal;

@RestController
@RequestMapping("/auth")
public class UserController {

    @Autowired
    private UserAuthService userAuthService;

    @Autowired
    ConsumerTokenServices consumerTokenServices;

    @RequestMapping(method = RequestMethod.DELETE, value = "/token")
    @ResponseBody
    public void revokeToken(HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.contains("Bearer")){
            String tokenId = authorization.substring("Bearer".length()+1);
            consumerTokenServices.revokeToken(tokenId);
        }
    }

    @RequestMapping(value = "/current", method = RequestMethod.GET)
    public Principal getUser(Principal principal) {
        return principal;
    }

    @RequestMapping(path = "/{name}/roles/{roles}", method = RequestMethod.PUT)
    public void updateRoles(@PathVariable String name, @PathVariable String roles) {
        userAuthService.updateRoles(name, roles);
    }

    @RequestMapping(path = "/{name}/addroles/{roles}", method = RequestMethod.PUT)
    public void addRoles(@PathVariable String name, @PathVariable String roles) {
        userAuthService.addRoles(name, roles);
    }

    @RequestMapping(method = RequestMethod.POST)
    public void createUser(@Valid @RequestBody User user) {
        userAuthService.create(user);
    }

    @RequestMapping(value = "/resetpasswd", method = RequestMethod.POST)
    public void resetUserPassword(@Valid @RequestBody User user) {
        userAuthService.resetUserPassword(user);
    }

    @RequestMapping(path = "/current/{name}", method = RequestMethod.DELETE)
    public void deleteUser(@PathVariable String name) {
        userAuthService.deleteUser(name);
    }

    @RequestMapping(method = RequestMethod.PUT)
    public void resetUser(@Valid @RequestBody User user) {
        userAuthService.reset(user);
    }

    @RequestMapping(path = "/{lockOrUnlock}",method = RequestMethod.PUT)
    public void lockOrUnlockUser(@Valid @RequestBody User user, @PathVariable String lockOrUnlock) {//@RequestParam("by") String by,
        if("lock".equals(lockOrUnlock)){
            userAuthService.lock(user,lockOrUnlock);
        }
        else if("unlock".equals(lockOrUnlock)){
            userAuthService.unlock(user,lockOrUnlock);
        }

    }





    @RequestMapping(path = "/{name}", method = RequestMethod.GET)
    public boolean lockState(@PathVariable String name) {
        return userAuthService.lockState(name);
    }

    @RequestMapping(path = "/verify/{name}/{code}", method = RequestMethod.PUT)
    public void verifyCode(@PathVariable String name, @PathVariable String code) {
        userAuthService.verifyCode(name, code);
    }

    @RequestMapping(path = "/changepass", method = RequestMethod.PUT)
    public void changePassword(@Valid @RequestBody UserPasswordReset userPasswordReset) {
        userAuthService.changePassword(userPasswordReset);
    }


    @PreAuthorize("#oauth2.hasScope('server')")
    @RequestMapping(path = "/updateuser",method = RequestMethod.PUT)
    public void updateUser(@Valid @RequestBody User user, @RequestParam String username) {//@RequestParam("by") String by,
        userAuthService.updateUser(username, user);
    }



}
