package com.edgec.browserbackend.browser.domain;

import com.edgec.browserbackend.browser.dto.Interval;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.ArrayList;
import java.util.List;

@Document(collection = "ipresource")
@JsonIgnoreProperties(ignoreUnknown = true)
public class IpResource {
    @Id
    private String id;
    private String addr;
    private IpType ipType = IpType.VENDOR;
    private Vendor vendor;
    private String region;
    private String regionCn;
    //0:正常, 1:已过期, 2:即将过期
    private int status;
    private List<String> port;
    private long purchasedTime;
    private long validTime;
    private String details;
    List<String> bindHistory = new ArrayList<>();
    private boolean isDeleted;
    private String username;
    private String owner;
    private String userParent;
    private String shopId;
    private String shopName;
    private List<String> protocol;
    private String password;

    public String getDetails() {
        return details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegionCn() {
        return regionCn;
    }

    public void setRegionCn(String regionCn) {
        this.regionCn = regionCn;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public IpType getIpType() {
        return ipType;
    }

    public void setIpType(IpType ipType) {
        this.ipType = ipType;
    }

    public List<String> getBindHistory() {
        return bindHistory;
    }

    public void setBindHistory(List<String> bindHistory) {
        this.bindHistory = bindHistory;
    }

    public long getPurchasedTime() {
        return purchasedTime;
    }

    public void setPurchasedTime(long purchasedTime) {
        this.purchasedTime = purchasedTime;
    }

    public long getValidTime() {
        return validTime;
    }

    public void setValidTime(long validTime) {
        this.validTime = validTime;
    }

    public Vendor getVendor() {
        return vendor;
    }

    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }

    public boolean isDeleted() {
        return isDeleted;
    }

    public void setDeleted(boolean deleted) {
        isDeleted = deleted;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public List<String> getPort() {
        return port;
    }

    public void setPort(List<String> port) {
        this.port = port;
    }

    public String getAddr() {
        return addr;
    }

    public void setAddr(String addr) {
        this.addr = addr;
    }

    public String getUserParent() {
        return userParent;
    }

    public void setUserParent(String userParent) {
        this.userParent = userParent;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getShopId() {
        return shopId;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }

    public List<String> getProtocol() {
        return protocol;
    }

    public void setProtocol(List<String> protocol) {
        this.protocol = protocol;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }
}
