package com.edgec.browserbackend.browser.dto;

import com.edgec.browserbackend.browser.domain.IpTransaction;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.ArrayList;
import java.util.List;

/**
 * @Desc
 * @Author jason
 * @CreateTime 2020/3/18 9:57 上午
 **/
@JsonIgnoreProperties(ignoreUnknown = true)
public class IpTransactionDto {
    private String tid;
    private int status;
    private List<IpResourceDto> ipResourceDtos;

    public IpTransactionDto(){

    }

    public IpTransactionDto(IpTransaction ipTransaction) {
        this.tid = ipTransaction.getTid();
        this.status = ipTransaction.getStatus();
        ipResourceDtos = new ArrayList<>();
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public List<IpResourceDto> getIpResourceDtos() {
        return ipResourceDtos;
    }

    public void setIpResourceDtos(List<IpResourceDto> ipResourceDtos) {
        this.ipResourceDtos = ipResourceDtos;
    }
}
