package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.domain.UserShop;
import org.springframework.data.mongodb.repository.MongoRepository;

import java.util.List;

public interface UserShopRepository extends MongoRepository<UserShop, String>, UserShopRepositoryCustom {
    List<UserShop> findByUsername(String username);
    List<UserShop> findByUsernameAndIpIdIsNull(String username);
    UserShop findByUsernameAndShopId(String username, String shopId);
    UserShop findByShopId(String shopId);
    List<UserShop> findByUsernameAndGroupId(String username, String groupId);
    List<UserShop> findByUsernameAndGroupIdAndIpIdIsNull(String username, String groupId);
    List<UserShop> findByUsernameAndGroupIdAndIpIdIsNotNull(String username, String groupId);
    List<UserShop> findByUsernameAndShopIdIn(String username, List<String> shopIds);
    List<UserShop> findByUsernameAndIpIdIsNotNull(String username);
    int countByUsernameAndIpIdIsNull(String username);
    int countByUsername(String username);
}
