package com.edgec.browserbackend.browser.service.Impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.edgec.browserbackend.account.domain.Account;
import com.edgec.browserbackend.account.domain.IpChargeRequestDto;
import com.edgec.browserbackend.account.domain.IpChargeResultDto;
import com.edgec.browserbackend.account.exception.AccountErrorCode;
import com.edgec.browserbackend.account.repository.AccountRepository;
import com.edgec.browserbackend.account.service.AccountService;
import com.edgec.browserbackend.browser.ErrorCode.BrowserErrorCode;
import com.edgec.browserbackend.browser.domain.*;
import com.edgec.browserbackend.browser.dto.*;
import com.edgec.browserbackend.browser.repository.*;
import com.edgec.browserbackend.browser.service.IpResourceService;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import com.edgec.browserbackend.common.utils.FileUtil;
import com.edgec.browserbackend.common.utils.ThreadPoolUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.io.File;
import java.time.Instant;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

@Service
public class IpResourceServiceImpl implements IpResourceService {

    private final Logger logger = LoggerFactory.getLogger(IpResourceServiceImpl.class);

    private static String CLOUDAMURL = "https://www.cloudam.cn";
    private static String TESTURL = "http://112.74.13.2";
    private static String USERNAME = "fangguanlianbrowser";

    private static List<String> port = Arrays.asList("20000", "20001");

    private static List<String> protocol = Arrays.asList("socks5", "proxy");

    private static String startscript = "";

    @Value("${spring.profiles.active}")
    private String profiles;

    @Autowired
    private AccountRepository accountRepository;

    @Autowired
    private IpResourceRepository ipResourceRepository;

    @Autowired
    private UserShopRepository userShopRepository;

    @Autowired
    private ShopRepository shopRepository;

    @Autowired
    private AccountService accountService;

    @Autowired
    private IpOptionsRepository ipOptionsRepository;

    @Autowired
    private PlatformOptionsRepository platformOptionsRepository;

    @Autowired
    private IpTransactionRepository ipTransactionRepository;

    public HttpHeaders buildPostHeader() {
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.APPLICATION_JSON);
        if (profiles.equals("dev"))
            header.setBearerAuth("oq5tg3gMsflHcK5iZ2741G5R30XYd9blyOqH9qeBItKtrzfTsGIoy8AsxqqNXdcm");
        else if (profiles.equals("prod"))
            header.setBearerAuth("tKWsuHzcngf0RQPMss70f9jgymDIwgQ9zbLfESJdcou3pZSNWl7lNTzto8VQgwaO");
        return header;
    }

    public HttpHeaders buildGetHeader() {
        HttpHeaders headers = new HttpHeaders();
        if (profiles.equals("dev"))
            headers.setBearerAuth("oq5tg3gMsflHcK5iZ2741G5R30XYd9blyOqH9qeBItKtrzfTsGIoy8AsxqqNXdcm");
        else if (profiles.equals("prod"))
            headers.setBearerAuth("tKWsuHzcngf0RQPMss70f9jgymDIwgQ9zbLfESJdcou3pZSNWl7lNTzto8VQgwaO");
        return headers;
    }

    public static String genRandom(int srcFlag, int length) {
        String retStr = "";
        String strTable = "";
        switch (srcFlag) {
            case 1:
                strTable = "1234567890";
                break;
            case 2:
                strTable = "1234567890abcdefghijklmnopqrstuvwxyz";
                break;
            case 3:
                strTable = "12345678901234567890abcdefghijkmnpqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
                break;
            case 4:
                strTable = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
                break;
            case 5:
                strTable = "abcdefghijklmnopqrstuvwxyz";
                break;
            default:
                strTable = "1234567890abcdefghijkmnpqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
                break;
        }

        int len = strTable.length();
        boolean bDone = true;
        do {
            retStr = "";
            int count = 0;
            for (int i = 0; i < length; i++) {
                double dblR = Math.random() * len;
                int intR = (int) Math.floor(dblR);
                char c = strTable.charAt(intR);
                if (('0' <= c) && (c <= '9')) {
                    count++;
                }
                retStr += strTable.charAt(intR);
            }
            if (count >= 2) {
                bDone = false;
            }
        } while (bDone);
        return retStr;
    }

    private IpChargeRequestDto buildIpChargeRequestDto(IpResourceRequestDto request, int chargeType) {
        IpChargeRequestDto ipChargeRequestDto = new IpChargeRequestDto();
        ipChargeRequestDto.setAmount(request.getAmount());
        ipChargeRequestDto.setChargeType(chargeType);
        ipChargeRequestDto.setRegion(request.getRegion());
        ipChargeRequestDto.setPeriod(request.getPeriod());
        ipChargeRequestDto.setUnit(request.getUnit());
        ipChargeRequestDto.setPayMethod(0);
        return ipChargeRequestDto;
    }

    @Override
    public IpTransactionDto buyIp(String username, IpResourceRequestDto ipResourceRequestDto) throws Exception {
        String URL = (profiles.equals("dev") || profiles.equals("staging"))? TESTURL : CLOUDAMURL;
        Account account = accountRepository.findByName(username);
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);
        if (account.getPermission() < 8)
            throw new ClientRequestException(AccountErrorCode.NOPERMISSION);

        Map<String, List<String>> priceList = ipOptionsRepository.findAll().get(0).getIpPlatForm();
        if (ipResourceRequestDto.getRegionCn() == null)
            throw new ClientRequestException(BrowserErrorCode.INFORMATIONNOTCOMPELETE);
        List<String> vendorPrices = priceList.get(ipResourceRequestDto.getRegionCn());
        String price = vendorPrices.stream()
                .filter(x ->  Vendor.valueOf(ipResourceRequestDto.getVendor()).getValue().equals(x.substring(0, x.indexOf("-"))))
                .map(x -> x.substring(x.lastIndexOf("-") + 1)).collect(Collectors.joining());
        IpChargeResultDto ipChargeResultDto = accountService.preChargeByMoney(username, Double.valueOf(price) * ipResourceRequestDto.getAmount());
        if (!ipChargeResultDto.isSuccess()) {
            throw new ClientRequestException(AccountErrorCode.NOTENOUGHBALANCE);
        }

        String password;
        if (StringUtils.isNotBlank(ipResourceRequestDto.getPassword()))
            password = ipResourceRequestDto.getPassword();
        else
            password = genRandom(3, 12);

        IpTransaction ipTransaction  = new IpTransaction();
        ipTransaction.setCreateTime(Instant.now().toEpochMilli());
        ipTransaction.setUsername(username);
        ipTransaction.setStatus(0);

        List<IpResourceDto> ipResourceDtos = new ArrayList<>();
        List<String> ipIds = new ArrayList<>();

        for (int i = 0; i < ipResourceRequestDto.getAmount(); i++) {
            IpResource ipResource = new IpResource();
            ipResource.setAddr("");
            ipResource.setIpType(IpType.VENDOR);
            ipResource.setPurchasedTime(Instant.now().toEpochMilli());
            ipResource.setValidTime(Instant.now().toEpochMilli());
            ipResource.setPort(port);
            ipResource.setVendor(Vendor.valueOf(ipResourceRequestDto.getVendor()));
            ipResource.setStatus(0);
            ipResource.setUsername(USERNAME);
            if (account.getParent() != null)
                ipResource.setUserParent(account.getParent());
            ipResource.setRegion(ipResourceRequestDto.getRegion());
            ipResource.setRegionCn(ipResourceRequestDto.getRegionCn());
            ipResource.setProtocol(protocol);
            ipResource.setPassword(password);
            ipResource.setOwner(username);
            IpResource ipResource1 = ipResourceRepository.save(ipResource);
            ipResourceDtos.add(new IpResourceDto(ipResource1, null));
            ipIds.add(ipResource1.getId());
        }

        ipTransaction.setIpIds(ipIds);
        ipTransactionRepository.save(ipTransaction);

        IpTransactionDto ipTransactionDto = new IpTransactionDto(ipTransaction);
        ipTransactionDto.setIpResourceDtos(ipResourceDtos);

        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(2000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders header = buildPostHeader();
            HashMap<String, Object> map = new HashMap<>();
            map.put("name", ipResourceRequestDto.getName());
            map.put("region", ipResourceRequestDto.getRegion());
            if (ipResourceRequestDto.getUnit().equals("month") && ipResourceRequestDto.getPeriod() == 6)
                ipResourceRequestDto.setPeriod(7);
            else if (ipResourceRequestDto.getUnit().equals("month") && ipResourceRequestDto.getPeriod() == 12)
                ipResourceRequestDto.setPeriod(14);
            map.put("period", String.valueOf(ipResourceRequestDto.getPeriod()));
            map.put("provider", ipResourceRequestDto.getVendor());
            map.put("unit", ipResourceRequestDto.getUnit());
            map.put("amount", String.valueOf(ipResourceRequestDto.getAmount()));
            map.put("loginPassword", password);
            map.put("startscript", startscript);
            map.put("ipkeptperiod", ipResourceRequestDto.getIpkeptperiod());
            HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<>(map, header);
            IpBuyResultDto ipBuyResultDto = null;
            try {
                ipBuyResultDto = restTemplate.postForObject(URL + "/intelligroup/ipresources?accountId=browser", httpEntity, IpBuyResultDto.class);
                if (StringUtils.isNotBlank(ipBuyResultDto.getErrorCode())) {
                    IpChargeRequestDto ipChargeRequestDto = buildIpChargeRequestDto(ipResourceRequestDto, 1);
                    accountService.chargeByMoney(username, -Double.valueOf(price)*ipChargeRequestDto.getAmount(), ipChargeRequestDto);
                    logger.error("fail to buy ip");
                    logger.error(ipBuyResultDto.getErrorCode());
                }
                if (ipBuyResultDto != null && ipBuyResultDto.getIplist() != null && ipBuyResultDto.getIplist().size() >= 1) {
                    AtomicInteger index = new AtomicInteger();
                    ipBuyResultDto.getIplist().forEach(x -> {
                        IpResource ipResource = ipResourceRepository.findById(ipResourceDtos.get(index.get()).getId()).orElse(null);
                        if (ipResource != null) {
                            ipResource.setAddr(x.getIp());
                            ipResource.setPurchasedTime(Instant.now().toEpochMilli());
                            ipResource.setValidTime(Instant.parse(x.getValidTill()).toEpochMilli());
                            ipResourceRepository.save(ipResource);
                        } else {
                            logger.error("no ipResource");
                        }
                        index.getAndIncrement();
                    });
                    if (ipBuyResultDto.getIplist().size() < ipResourceDtos.size()) {
                        IpChargeRequestDto ipChargeRequestDto = buildIpChargeRequestDto(ipResourceRequestDto, 1);
                        accountService.chargeByMoney(username, -Double.valueOf(price)*(ipResourceDtos.size() - ipBuyResultDto.getIplist().size()), ipChargeRequestDto);
                    }
                }
                ipTransaction.setStatus(1);
                ipTransactionRepository.save(ipTransaction);
            } catch (Exception e) {
                logger.error(e.getMessage());
            }
        }, ThreadPoolUtils.taskExecutorPool);

        IpChargeRequestDto ipChargeRequestDto = buildIpChargeRequestDto(ipResourceRequestDto, 1);
        accountService.chargeByMoney(username, Double.valueOf(price) * ipChargeRequestDto.getAmount(), ipChargeRequestDto);
        return ipTransactionDto;
    }

    @Override
    public IpOperationResultDto renewIp(String username, IpResourceRequestDto ipResourceRequestDto) {
        String URL = (profiles.equals("dev") || profiles.equals("staging"))? TESTURL : CLOUDAMURL;
        Account account = accountRepository.findByName(username);
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);

        List<String> failedList = ipResourceRequestDto.getAddr();

        Map<String, List<String>> priceList = ipOptionsRepository.findAll().get(0).getIpPlatForm();

        double totalprice = ipResourceRequestDto.getAddr().stream().map(x -> ipResourceRepository.findByAddrAndIsDeleted(x, false)).map(ipResource -> priceList.get(ipResource.getRegionCn())).map(vendorPrices -> vendorPrices.stream()
                .filter(vendorprice -> Vendor.valueOf(ipResourceRequestDto.getVendor()).getValue().equals(vendorprice.substring(0, vendorprice.indexOf("-"))))
                .map(vendorprice -> vendorprice.substring(vendorprice.lastIndexOf("-") + 1)).collect(Collectors.joining())).mapToDouble(Double::valueOf).sum();

        IpChargeResultDto ipChargeResultDto = accountService.preChargeByMoney(username, Double.valueOf(totalprice));
        if (!ipChargeResultDto.isSuccess()) {
            throw new ClientRequestException(AccountErrorCode.NOTENOUGHBALANCE);
        }

        RestTemplate restTemplate = new RestTemplate();
        HashMap<String, Object> map = new HashMap<>();
        map.put("iplist", ipResourceRequestDto.getAddr());
        if (ipResourceRequestDto.getUnit().equals("month") && ipResourceRequestDto.getPeriod() == 6)
            ipResourceRequestDto.setPeriod(7);
        else if (ipResourceRequestDto.getUnit().equals("month") && ipResourceRequestDto.getPeriod() == 12)
            ipResourceRequestDto.setPeriod(14);
        map.put("period", ipResourceRequestDto.getPeriod());
        HttpHeaders headers = buildPostHeader();
        HttpEntity<Map<String, Object>> entity = new HttpEntity<>(map, headers);
        ResponseEntity<String> result = restTemplate.exchange(URL + "/intelligroup/renewip?accountId=browser", HttpMethod.PUT, entity, String.class);
        RenewIpResultDto renewIpResultDto = JSON.parseObject(result.getBody(), RenewIpResultDto.class);
        if (StringUtils.isNotBlank(renewIpResultDto.getErrorCode())) {
            logger.error(renewIpResultDto.getErrorCode());
            throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
        }
        IpOperationResultDto ipOperationResultDto = new IpOperationResultDto();

        renewIpResultDto.getIplist().forEach(x -> {
            IpResource ipResource = ipResourceRepository.findByAddrAndIsDeleted(x.getIp(), false);
            List<String> vendorPrices = priceList.get(ipResource.getRegionCn());
            String price = vendorPrices.stream()
                    .filter(vendorprice -> Vendor.valueOf(ipResourceRequestDto.getVendor()).getValue().equals(vendorprice.substring(0, vendorprice.indexOf("-"))))
                    .map(vendorprice -> vendorprice.substring(vendorprice.lastIndexOf("-") + 1)).collect(Collectors.joining());

            IpChargeRequestDto ipChargeRequestDto = buildIpChargeRequestDto(ipResourceRequestDto, 2);
            accountService.chargeByMoney(username, Double.valueOf(price), ipChargeRequestDto);

            ipResource.setValidTime(Instant.parse(x.getValidTill()).toEpochMilli());
            ipResourceRepository.save(ipResource);
            ipOperationResultDto.getSuccessList().add(x.getIp());

            failedList.remove(x.getIp());
        });

        ipOperationResultDto.setFailList(failedList);

        return ipOperationResultDto;
    }

    @Override
    public IpOperationResultDto deleteIp(String username, List<String> ipAddrs) {
        String URL = (profiles.equals("dev") || profiles.equals("staging"))? TESTURL : CLOUDAMURL;
        Account account = accountRepository.findByName(username);
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);
        IpOperationResultDto ipOperationResultDto = new IpOperationResultDto();
        ipAddrs.forEach(ipAddr -> {
            IpResource ipResource = ipResourceRepository.findByAddrAndIsDeleted(ipAddr, false);
            if (ipResource == null) {
                ipOperationResultDto.getFailList().add(ipAddr);
                return;
            }
            UserShop userShop = null;
            if (ipResource.getShopId() != null) {
                userShop = userShopRepository.findByUsernameAndShopId(username, ipResource.getShopId());
                if (userShop == null) {
                    ipOperationResultDto.getFailList().add(ipAddr);
                    return;
                }
            } else if (!ipResource.getOwner().equals(username)) {
                ipOperationResultDto.getFailList().add(ipAddr);
                return;
            }
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = buildGetHeader();
            Map<String, String> params = new HashMap<String, String>();
            HttpEntity<Map<String, String>> httpEntity = new HttpEntity<>(params, headers);
            try {
                ResponseEntity<String> result = restTemplate.exchange(URL + "/intelligroup/ipresources?accountId=browser&ip={ip}", HttpMethod.DELETE, httpEntity, String.class, ipAddr);
                DeleteIpResultDto deleteIpResultDto = JSON.parseObject(result.getBody(), DeleteIpResultDto.class);
                if (StringUtils.isNotBlank(deleteIpResultDto.getErrorCode()))
                    throw new Exception(deleteIpResultDto.getErrorCode());
                ipResource.setDeleted(true);
                ipResourceRepository.save(ipResource);
                if (userShop != null){
                    Shop shop = shopRepository.findById(ipResource.getShopId()).orElse(null);
                    if (shop != null) {
                        shop.setIp(null);
                        shop.setIpId(null);
                        shop.setIpRegion(null);
                        shopRepository.save(shop);
                    }
                    userShop.setIpId(null);
                    userShopRepository.save(userShop);
                }
                ipOperationResultDto.getSuccessList().add(ipAddr);
            } catch (Exception e) {
                logger.error("fail to renew ip", e.getMessage());
                ipOperationResultDto.getFailList().add(ipAddr);
                return;
            }
        });
        return ipOperationResultDto;
    }

    @Override
    public IpPageResultDto getIpList(String username, int groupType, int page, int amount, IpFilterDto ipFilterDto) {
        if (amount > 100)
            amount = 100;
        Pageable pageable = PageRequest.of(page, amount);
        Account account = accountRepository.findByName(username);
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);

        List<String> ipIds = userShopRepository.findByUsername(username).stream().filter(x -> (x.getShopId() != null && x.getIpId() != null))
                .map(x -> x.getIpId()).collect(Collectors.toList());

        List<IpResource> ipResources = new ArrayList<>();
        List<IpResource> notUsed = null;
        switch (groupType) {
            case 1:
                ipResources = ipResourceRepository.findByIdInAndIsDeleted(ipIds, false);;
                notUsed = ipResourceRepository.findByOwnerAndIsDeletedAndShopIdIsNull(username, false);
                break;
            case 2:
                ipResources = ipResourceRepository.findByStatusAndIdInAndIsDeleted(2, ipIds, false);
                notUsed = ipResourceRepository.findByOwnerAndStatusAndIsDeletedAndShopIdIsNull(username, 2, false);
                break;
            case 3:
                ipResources = ipResourceRepository.findByStatusAndIdInAndIsDeleted(1, ipIds, false);
                notUsed = ipResourceRepository.findByOwnerAndStatusAndIsDeletedAndShopIdIsNull(username, 1, false);
                break;
            case 4:
                notUsed = ipResourceRepository.findByOwnerAndIsDeletedAndShopIdIsNull(username, false);
                break;
        }
        if (notUsed != null)
            ipResources.addAll(notUsed);
        List<IpResourceDto> ipResourceDtos = new ArrayList<>();
        List<String> allIpIds = ipResources.stream().map(x -> x.getId()).collect(Collectors.toList());
        Page<IpResource> ipResources1 = null;
        if (ipFilterDto != null && StringUtils.isNotBlank(ipFilterDto.getRegion())) {
            ipResources1 = ipResourceRepository.findByRegionLikeAndIdInAndIsDeletedOrderByPurchasedTimeDesc(ipFilterDto.getRegion(), allIpIds, false, pageable);
        }
        else if (ipFilterDto != null && StringUtils.isNotBlank(ipFilterDto.getAddr())) {
            ipResources1 = ipResourceRepository.findByAddrLikeAndIdInAndIsDeletedOrderByPurchasedTimeDesc(ipFilterDto.getAddr(), allIpIds, false, pageable);
        }
        else if (ipFilterDto != null && StringUtils.isNotBlank(ipFilterDto.getVendor())) {
            ipResources1 = ipResourceRepository.findByVendorLikeAndIdInAndIsDeletedOrderByPurchasedTimeDesc(ipFilterDto.getVendor(), allIpIds, false, pageable);
        } else  {
            ipResources.forEach(x -> {
                ShopDto shopDto;
                if (x.getShopId() == null) {
                    shopDto = new ShopDto();
                } else {
                    Shop shop = shopRepository.findById(x.getShopId()).orElse(null);
                    if (shop != null)
                        shopDto = new ShopDto(shop);
                    else
                        shopDto = new ShopDto();
                }
                if (x.getValidTime() <= Instant.now().plusSeconds(60*60*24*7).toEpochMilli() && x.getValidTime() >Instant.now().toEpochMilli()) {
                    x.setStatus(2);
                    ipResourceRepository.save(x);
                }
                else if (x.getValidTime() <= Instant.now().minusSeconds(60*60*24*7).toEpochMilli()) {
                    deleteIp(username, Arrays.asList(x.getAddr()));
                    return;
                }
                else if (x.getValidTime() <= Instant.now().toEpochMilli()) {
                    x.setStatus(1);
                    ipResourceRepository.save(x);
                }
                else {
                    x.setStatus(0);
                    ipResourceRepository.save(x);
                }
                ipResourceDtos.add(new IpResourceDto(x, shopDto));
            });
        }
        if (ipResources1 != null) {
            ipResources1.getContent().forEach(x -> {
                ShopDto shopDto;
                if (x.getShopId() == null) {
                    shopDto = new ShopDto();
                } else {
                    Shop shop = shopRepository.findById(x.getShopId()).orElse(null);
                    if (shop != null)
                        shopDto = new ShopDto(shop);
                    else
                        shopDto = new ShopDto();
                }
                if (x.getValidTime() <= Instant.now().plusSeconds(60*60*24*7).toEpochMilli() && x.getValidTime() >Instant.now().toEpochMilli()) {
                    x.setStatus(2);
                    ipResourceRepository.save(x);
                }
                else if (x.getValidTime() <= Instant.now().minusSeconds(60*60*24*7).toEpochMilli()) {
                    deleteIp(username, Arrays.asList(x.getAddr()));
                    return;
                }
                else if (x.getValidTime() <= Instant.now().toEpochMilli()) {
                    x.setStatus(1);
                    ipResourceRepository.save(x);
                }
                else {
                    x.setStatus(0);
                    ipResourceRepository.save(x);
                }
                ipResourceDtos.add(new IpResourceDto(x, shopDto));
            });
        }

        Page<IpResourceDto> ipResourceDtoPage = new PageImpl<>(ipResourceDtos, pageable, allIpIds.size());
        IpPageResultDto ipPageResultDto = new IpPageResultDto();
        ipPageResultDto.setIpList(ipResourceDtoPage.getContent());
        PageInfo pageInfo = new PageInfo();
        pageInfo.setCurrentPage(ipResourceDtoPage.getPageable().getPageNumber());
        pageInfo.setTotalPages(ipResourceDtoPage.getTotalPages());
        pageInfo.setTotalItems(allIpIds.size());
        ipPageResultDto.setIpPage(pageInfo);
        return ipPageResultDto;
    }

    @Override
    public void setIpOptions() {
        String path = ClassLoader.getSystemResource("ipOptions.json").getPath();
        IpOptions jsonObject = JSONObject.parseObject(FileUtil.read(new File(path), "UTF-8"), IpOptions.class);
        ipOptionsRepository.save(jsonObject);
    }

    @Override
    public IpOptions getIpOptions() {
        try {
            IpOptions jsonObject = ipOptionsRepository.findAll().get(0);
            return jsonObject;
        } catch (Exception e) {
            logger.error(e.getMessage());
            throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
        }
    }

    @Override
    public List<PlatformOptions> getPlatformOptions() {
        try {
            List<PlatformOptions> platformOptions = platformOptionsRepository.findAll();
            return platformOptions;
        } catch (Exception e) {
            logger.error(e.getMessage());
            throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
        }
    }

    @Override
    public IpTransactionDto queryTransaction(String username, String tid) {
        Account account = accountRepository.findByName(username);
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);
        if (account.getPermission() < 8)
            throw new ClientRequestException(AccountErrorCode.NOPERMISSION);
        IpTransaction ipTransaction = ipTransactionRepository.findById(tid).orElse(null);
        if (ipTransaction == null)
            throw new ClientRequestException(BrowserErrorCode.IPTRANSACTIONNOTEXIST);
        IpTransactionDto ipTransactionDto = new IpTransactionDto(ipTransaction);
        for (String id : ipTransaction.getIpIds()) {
            IpResource ipResource = ipResourceRepository.findById(id).orElse(null);
            if (ipResource != null) {
                IpResourceDto ipResourceDto = new IpResourceDto(ipResource, null);
                ipTransactionDto.getIpResourceDtos().add(ipResourceDto);
            }
        }
        //                    IpInfoResultDto ipInfoResultDto = new IpInfoResultDto();
//                    Map<String, String> params = new HashMap<String, String>();
//                    params.put("accountId", "browser");
//                    params.put("ip", x.getIp());
//                    HttpHeaders headers = buildGetHeader();
//                    HttpEntity<Map<String, String>> entity = new HttpEntity<>(params, headers);
//                    ResponseEntity<String> result = restTemplate.exchange(TESTURL + "/ecc/ipinfo?accountId={accountId}&ip={ip}", HttpMethod.GET, entity, String.class);
//                    JSONObject jsonObject = JSON.parseObject(result.getBody());
//                    if (ipInfoResultDto != null && StringUtils.isBlank(ipInfoResultDto.getErrorCode())) {
        //                        ipResource.setPurchasedTime(Long.valueOf((String) jsonObject.get("createdWhen")));
//                        ipResource.setValidTime(Long.valueOf((String)jsonObject.get("validTill")));
        //                    }
        return ipTransactionDto;
    }

    @Override
    public IpSummary getIpSummary(String username) {
        Account account = accountRepository.findByName(username);
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);
        IpSummary ipSummary = new IpSummary();
        List<String> used = userShopRepository.findByUsernameAndIpIdIsNotNull(username).stream().map(x -> x.getIpId()).collect(Collectors.toList());
        List<String> unbind = ipResourceRepository.findByOwnerAndIsDeletedAndShopIdIsNull(username, false).stream().map(x -> x.getId()).collect(Collectors.toList());
        ipSummary.setUnbind(unbind.size());
        unbind.addAll(used);
        int expired = ipResourceRepository.countByStatusAndIdInAndIsDeleted(1, unbind, false);
        ipSummary.setExpired(expired);
        int willexpired = ipResourceRepository.countByStatusAndIdInAndIsDeleted(2, unbind, false);
        ipSummary.setWillExpire(willexpired);
        ipSummary.setTotal(unbind.size());
        return ipSummary;
    }
}
