package com.edgec.browserbackend.common.utils;

import com.edgec.browserbackend.browser.ErrorCode.BrowserErrorCode;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

/**
 * @Desc
 * @Author jason
 * @CreateTime 2020/3/11 7:36 下午
 **/
public class FileUtil {
    private static Logger log = LoggerFactory.getLogger(FileUtil.class);
    private static final String CHARSET = "UTF-8";

    public static String read(File f, String charset) {
        String line = null;
        StringBuffer buf = new StringBuffer();
        try (InputStreamReader reader = new InputStreamReader(new FileInputStream(f), charset);
             BufferedReader br = new BufferedReader(reader);){
            while ((line = br.readLine()) != null) {
                buf.append(line+System.getProperty("line.separator"));
            }
        } catch (Exception e) {
            log.error("[" + f.getName() + "]文件读出失败{}",e);
            return null;
        }
        log.debug("[" + f.getName() + "]文件读出成功");
        return buf.toString();
    }

    public static List<String> readLine(File f, String charset) {
        String line = null;
        List<String> lineList = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        try (InputStreamReader reader = new InputStreamReader(new FileInputStream(f), charset);
             BufferedReader br = new BufferedReader(reader);){
            while ((line = br.readLine()) != null) {
                lineList.add(line);
            }
            br.close();
            reader.close();
        } catch (Exception e) {
            log.error("[" + f.getName() + "]文件读出失败{}",e);
            return null;
        }
        log.debug("[" + f.getName() + "]文件读出成功");
        return lineList;
    }

    public static boolean write(String content, File file) {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file))){
            bw.write(content);
        } catch (Exception e) {
            log.error("[" + file.getName() + "]写入失败{}",e);
            return false;
        }
        log.debug("[" + file.getName() + "]文件写入成功");
        return true;
    }

    //读取excel
    public static List<List<Object>> readExcel(InputStream inputStream){
        List<List<Object>> list = new ArrayList<>();
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create(inputStream);
            inputStream.close();
            //工作表对象
            Sheet sheet = workbook.getSheetAt(0);

            //总行数
            int rowLength = sheet.getLastRowNum() -1;
            //工作表的列
            Row row = sheet.getRow(0);

            //总列数
            int colLength = row.getLastCellNum();
            //得到指定的单元格
            Cell cell = row.getCell(0);;
            int size = 1;
            for (int i = 1; i < rowLength + 2; i++) {
                row = sheet.getRow(i);
                List<Object> rowvalue = new ArrayList<>();
                size = 0;
                for (int j = 0; j < colLength; j++) {
                    cell = row.getCell(j);
//                    System.out.println(cell);
                    if (cell!=null) {
                        Object cellValue = getCellFormatValue(cell);
                        rowvalue.add(cellValue);
                        if (StringUtils.isNotBlank(cellValue.toString())) {
                            size++;
                        }
                    }
                }
                if (size == 0)
                    break;
                if (StringUtils.isBlank(rowvalue.get(0).toString()) || StringUtils.isBlank(rowvalue.get(1).toString()))
                    throw new ClientRequestException(BrowserErrorCode.INFORMATIONNOTCOMPELETE);
                list.add(rowvalue);
            }
        } catch (Exception e) {
            log.error("parse excel file error :", e);
            throw new ClientRequestException(BrowserErrorCode.INFORMATIONNOTCOMPELETE);
        }
        return list ;
    }

    public static Object getCellFormatValue(Cell cell){
        Object cellValue = null;
        if(cell!=null){
            //判断cell类型
            switch(cell.getCellType()){
                case Cell.CELL_TYPE_NUMERIC:{
                    cellValue = String.valueOf((int)cell.getNumericCellValue());
                    break;
                }
                case Cell.CELL_TYPE_FORMULA:{
                    //判断cell是否为日期格式
                    if(DateUtil.isCellDateFormatted(cell)){
                        //转换为日期格式YYYY-mm-dd
                        cellValue = cell.getDateCellValue();
                    }else{
                        //数字
                        cellValue = String.valueOf(cell.getNumericCellValue());
                    }
                    break;
                }
                case Cell.CELL_TYPE_STRING:{
                    cellValue = cell.getRichStringCellValue().getString();
                    break;
                }
                default:
                    cellValue = "";
            }
        }else{
            cellValue = "";
        }
        return cellValue;
    }


}
