package com.edgec.browserbackend.browser.domain;

import com.edgec.browserbackend.common.utils.Aes;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.validation.constraints.NotEmpty;

/**
 * @author xuxin
 * @date 2020/8/13 10:49
 * @description
 */
@Data
@Document("vps")
@JsonIgnoreProperties(ignoreUnknown = true)
public class Vps {
    /**
     * vps id
     */
    @Id
    private String id;

    /**
     * vps ip
     */
    @NotEmpty
    private String vpsIp;

    /**
     * vps 登录名
     */
    @NotEmpty
    private String vpsUser;

    /**
     * vps 登录密码
     */
    @NotEmpty
    private String vpsPassword;

    /**
     * vps 所绑定的店铺名
     */
    @NotEmpty
    private String vpsShopName;

    /**
     * vps 创建者，即当前登录用户
     */
    private String owner1;

    /**
     * vps 创建者的父账号id
     */
    private String owner2;

    /**
     * ip的购买时间点
     */
    private long createTime;

    public String getVpsPassword() {
        return Aes.aesDecrypt(vpsPassword);
    }

    public void setVpsPassword(String vpsPassword) {
        this.vpsPassword = Aes.aesEncrypt(vpsPassword);
    }
}
