package com.edgec.browserbackend.account.repository;

import com.edgec.browserbackend.account.domain.BillStatus;
import com.edgec.browserbackend.account.domain.UserPrePaidBilling;
import org.omg.PortableServer.LIFESPAN_POLICY_ID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Repository;

import java.util.Arrays;
import java.util.List;

@Repository
public interface UserPrePaidBillingRepository extends MongoRepository<UserPrePaidBilling, String>, UserPrePaidBillingRepositoryCustom {

    List<UserPrePaidBilling> findByUsernameAndServicesAndYearAndMonth(String username, String services, int year, int month);

    List<UserPrePaidBilling> findByUsernameAndStatus(String username, BillStatus billStatus);

    List<UserPrePaidBilling> findByUsername(String username);

    Page<UserPrePaidBilling> findAllByUsername(String username, Pageable pageable);

    Page<UserPrePaidBilling> findAllByYearBetweenAndMonthBetween(Pageable pageable, int year1, int year2, int month1, int month2);

    List<UserPrePaidBilling> findByUsernameAndYearAndMonthAndPayMethodIn(String username, int year, int month, List<Integer> payMethod);

    List<UserPrePaidBilling> findByUsernameAndPayMethodIn(String username, List<Integer> payMethod);

    List<UserPrePaidBilling> findByUsernameAndPayMethod(String username, int payMethod);

    List<UserPrePaidBilling> findByUsernameAndChargeType(String username, int chargeType);

    List<UserPrePaidBilling> findByYearAndMonth(int year, int month);

    List<UserPrePaidBilling> findByStatus(BillStatus status);

    List<UserPrePaidBilling> findByUsernameAndPayMethodInAndTimestampGreaterThanAndTimestampLessThan(String username, List<Integer> payMehtods, long time1, long time2);

    List<UserPrePaidBilling> findByUsernameAndChargeTypeAndTimestampGreaterThanAndTimestampLessThan(String username, int chargeType, long time1, long time2);

    Page<UserPrePaidBilling> findByUsernameAndTimestampGreaterThanOrderByTimestampDesc(String username, long time, Pageable pageable);

    Page<UserPrePaidBilling> findByAdministratorAndTimestampGreaterThanOrderByTimestampDesc(String administrator, long time, Pageable pageable);

    Page<UserPrePaidBilling> findByUsernameAndTimestampGreaterThanAndChargeTypeOrderByTimestampDesc(String username, long time, int chargeType, Pageable pageable);

    Page<UserPrePaidBilling> findByAdministratorAndTimestampGreaterThanAndChargeTypeOrderByTimestampDesc(String administrator, long time, int chargeType, Pageable pageable);

    Page<UserPrePaidBilling> findByUsernameAndTimestampGreaterThanAndChargeTypeIsNotAndPayMethodOrderByTimestampDesc(String username, long time, int chargeType, int payMethod, Pageable pageable);

    Page<UserPrePaidBilling> findByAdministratorAndTimestampGreaterThanAndChargeTypeIsNotAndPayMethodOrderByTimestampDesc(String administrator, long time, int chargeType, int payMethod, Pageable pageable);
}
