package com.edgec.browserbackend.browser.domain;

import com.edgec.browserbackend.browser.dto.OperationHistoryDto;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

@Document(collection = "operationhistory")
public class OperationHistory {
    @Id
    private String id;
    private String username;
    private String nickname;
    private String loginIp;
    private String loginPlace;
    private String operation;
    private long operationTime;
    private String administrator;

    public OperationHistory() {

    }

    public OperationHistory(OperationHistoryDto operationHistoryDto) {
        if (operationHistoryDto.getAccount() != null)
            this.username = operationHistoryDto.getAccount();
        if (operationHistoryDto.getNickname() != null)
            this.nickname = operationHistoryDto.getNickname();
        if (operationHistoryDto.getLoginIp() != null)
            this.loginIp = operationHistoryDto.getLoginIp();
        if (operationHistoryDto.getLoginPlace() != null)
            this.loginPlace = operationHistoryDto.getLoginPlace();
        if (operationHistoryDto.getOperation() != null)
            this.operation = operationHistoryDto.getOperation();
        if (operationHistoryDto.getOperationTime() != null) {
            DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime localDateTime = LocalDateTime.parse(operationHistoryDto.getOperationTime(), format);
            this.operationTime = localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
        }
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public long getOperationTime() {
        return operationTime;
    }

    public void setOperationTime(long operationTime) {
        this.operationTime = operationTime;
    }

    public String getLoginIp() {
        return loginIp;
    }

    public void setLoginIp(String loginIp) {
        this.loginIp = loginIp;
    }

    public String getLoginPlace() {
        return loginPlace;
    }

    public void setLoginPlace(String loginPlace) {
        this.loginPlace = loginPlace;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getOperation() {
        return operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getAdministrator() {
        return administrator;
    }

    public void setAdministrator(String administrator) {
        this.administrator = administrator;
    }
}
