package com.edgec.browserbackend.browser.task;

import com.edgec.browserbackend.account.domain.Account;
import com.edgec.browserbackend.account.domain.Promotion;
import com.edgec.browserbackend.account.domain.UserPrePaidBilling;
import com.edgec.browserbackend.account.repository.AccountRepository;
import com.edgec.browserbackend.account.repository.UserPrePaidBillingRepository;
import net.javacrumbs.shedlock.core.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.Instant;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;

@Component
public class PromotionTask {

    private static final Logger log = LoggerFactory.getLogger(PromotionTask.class);

    @Autowired
    private AccountRepository accountRepository;

    @Autowired
    private UserPrePaidBillingRepository userPrePaidBillingRepository;

    @SchedulerLock(name = "transferExpiredScalingGroups", lockAtLeastForString = "PT1H", lockAtMostForString = "PT2H")
    @Scheduled(cron = "0 0 1 1 * ?")
    public void countGift() {
        List<Account> accounts = accountRepository.findByParentIsNull();
        for (Account account : accounts) {
            String code = account.getPromotion().getCode();
            List<Account> promotes = accountRepository.findByPromotionCode(code);
            double totalCommission = 0;
            double secondCommission = 0;
            for (Account promote : promotes) {
                List<UserPrePaidBilling> userPrePaidBillings = userPrePaidBillingRepository.findByUsernameAndYearAndMonthAndPayMethodIn(promote.getName(),
                        YearMonth.now().minusMonths(1).getYear(),
                        YearMonth.now().minusMonths(1).getMonthValue(), Arrays.asList(1,2,3));
                totalCommission += userPrePaidBillings.stream().mapToDouble(UserPrePaidBilling::getTotal).sum();
                if (account.getPromotion().isSale() && promote.getParent() == null) {
                    List<Account> secondPromotes = accountRepository.findByPromotionCode(promote.getPromotion().getCode());
                    if (secondPromotes != null && secondPromotes.size() > 0) {
                        for (Account secondPromote : secondPromotes) {
                            List<UserPrePaidBilling> userPrePaidBillings1 = userPrePaidBillingRepository.findByUsernameAndYearAndMonthAndPayMethodIn(secondPromote.getName(),
                                    YearMonth.now().minusMonths(1).getYear(),
                                    YearMonth.now().minusMonths(1).getMonthValue(), Arrays.asList(1,2,3));
                            secondCommission += userPrePaidBillings1.stream().mapToDouble(UserPrePaidBilling::getTotal).sum();
                        }
                    }
                }
            }
            Promotion promotion = account.getPromotion();
            promotion.setTotalCommission((int)(promotion.getTotalCommission() + totalCommission));
            promotion.setCommissionLastMonth((int)totalCommission);
            promotion.setGift(totalCommission * 0.08);
            if (account.getPromotion().isSale()) {
                promotion.setGift(totalCommission * 0.1 + secondCommission * 0.02);
            }
            promotion.setAllGift(promotion.getAllGift() + promotion.getGift());
            accountRepository.save(account);
        }
    }

    @SchedulerLock(name = "transferExpiredScalingGroups", lockAtLeastForString = "PT1H", lockAtMostForString = "PT2H")
    @Scheduled(cron = "0 0 1 * * ?")
    public void countCommission() {
        List<Account> accounts = accountRepository.findByParentIsNull();
        for (Account account : accounts) {
            String code = account.getPromotion().getCode();
            List<Account> promotes = accountRepository.findByPromotionCode(code);
            double totalCommission = 0;
            double secondCommission = 0;
            for (Account promote : promotes) {
                List<UserPrePaidBilling> userPrePaidBillings = userPrePaidBillingRepository.findByUsernameAndYearAndMonthAndPayMethodIn(promote.getName(),
                        YearMonth.now().getYear(),
                        YearMonth.now().getMonthValue(), Arrays.asList(1,2,3));
                totalCommission += userPrePaidBillings.stream().mapToDouble(UserPrePaidBilling::getTotal).sum();
                if (account.getPromotion().isSale() && promote.getParent() == null) {
                    List<Account> secondPromotes = accountRepository.findByPromotionCode(promote.getPromotion().getCode());
                    if (secondPromotes != null && secondPromotes.size() > 0) {
                        for (Account secondPromote : secondPromotes) {
                            List<UserPrePaidBilling> userPrePaidBillings1 = userPrePaidBillingRepository.findByUsernameAndYearAndMonthAndPayMethodIn(secondPromote.getName(),
                                    YearMonth.now().getYear(),
                                    YearMonth.now().getMonthValue(), Arrays.asList(1,2,3));
                            secondCommission += userPrePaidBillings1.stream().mapToDouble(UserPrePaidBilling::getTotal).sum();
                        }
                    }
                }
            }
            Promotion promotion = account.getPromotion();
            promotion.setCommission((int)totalCommission);
            promotion.setGift(totalCommission * 0.08);
            if (account.getPromotion().isSale()) {
                promotion.setGift(totalCommission * 0.1 + secondCommission * 0.02);
            }
            accountRepository.save(account);
        }
    }
}
