package com.edgec.browserbackend.account.controller;

import com.edgec.browserbackend.account.domain.Account;
import com.edgec.browserbackend.account.domain.AccountDto;
import com.edgec.browserbackend.account.dto.ResultDto;
import com.edgec.browserbackend.account.dto.SubUsersRequestDto;
import com.edgec.browserbackend.account.service.AccountService;
import com.edgec.browserbackend.browser.dto.ShopRequestDto;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/admin")
public class AdminController {

    @Autowired
    AccountService accountService;

    @RequestMapping(path = "/subuser/addone", method = RequestMethod.POST)
    public ResultDto createSubAccount(Principal principal, @Valid @RequestBody AccountDto user) {
        ResultDto resultDto = new ResultDto();
        try {
            LimitedUsers.filterIfLimitedUser(principal);
            Account account = accountService.createSub(principal.getName(), user);
            resultDto.setStatus(0);
            resultDto.setData(account);
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(path = "/subuser/add", method = RequestMethod.POST)
    public ResultDto createSubUsers(Principal principal, @RequestBody SubUsersRequestDto subUsersRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            LimitedUsers.filterIfLimitedUser(principal);
            accountService.createSubUsers(principal.getName(), subUsersRequestDto);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(path = "/subuser/updateone", method = RequestMethod.PUT)
    public ResultDto saveSubAccount(Principal principal, @PathVariable String child, @Valid @RequestBody AccountDto user) {
        ResultDto resultDto = new ResultDto();
        try {
            LimitedUsers.filterIfLimitedUser(principal);
            Account account1 =accountService.saveSub(principal.getName(), user);
            resultDto.setStatus(0);
            resultDto.setData(account1);
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(path = "/subuser/update", method = RequestMethod.POST)
    public ResultDto saveSubUsers(Principal principal, @RequestBody SubUsersRequestDto subUsersRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            LimitedUsers.filterIfLimitedUser(principal);
            accountService.saveSubUsers(principal.getName(), subUsersRequestDto);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(path = "/subuser/del", method = RequestMethod.DELETE)
    public ResultDto deleteSubAccount(Principal principal, @PathVariable String child) {
        ResultDto resultDto = new ResultDto();
        try {
            LimitedUsers.filterIfLimitedUser(principal);
            accountService.deleteSub(principal.getName(), child);
            resultDto.setStatus(0);
        }catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }

        return resultDto;
    }

    @RequestMapping(path = "/subuser/list", method = RequestMethod.POST)
    public ResultDto getSubUserList(Principal principal, @RequestBody ShopRequestDto shopRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            LimitedUsers.filterIfLimitedUser(principal);
            resultDto.setData(accountService.getSubUserList(principal.getName(), shopRequestDto.getPage(), shopRequestDto.getAmount()));
            resultDto.setStatus(0);
        }catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }

        return resultDto;
    }

}
