package com.edgec.browserbackend.account.domain;

import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Email;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class User {

    @Length(min = 3, max = 20, message="Name length should be between 3 - 20")
    private String username;

    @Length(min = 6, max = 40, message="Password length should be between 6 - 40")
    private String password;

    @Email(message ="Invalid email address")
    private String email;

    private String phone;

    private String authCode;

    private boolean enabled = false;

    private String lockReason;

    public String getAuthCode() {
        return authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    private boolean allowedToCreateSubUser = true;

    private int permission;

    private List<String> whiteList = new ArrayList<>();

    private String verificationCode= UUID.randomUUID().toString();

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getVerificationCode() {
        return verificationCode;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }


    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAllowedToCreateSubUser() {
        return allowedToCreateSubUser;
    }

    public void setAllowedToCreateSubUser(boolean allowedToCreateSubUser) {
        allowedToCreateSubUser = allowedToCreateSubUser;
    }

    public int getPermission() {
        return permission;
    }

    public void setPermission(int permission) {
        this.permission = permission;
    }

    public String getLockReason() {
        return lockReason;
    }

    public void setLockReason(String lockReason) {
        this.lockReason = lockReason;
    }

    public List<String> getWhiteList() {
        return whiteList;
    }

    public void setWhiteList(List<String> whiteList) {
        this.whiteList = whiteList;
    }
}
