package com.edgec.browserbackend.account.repository;

import com.edgec.browserbackend.account.domain.BillStatus;
import com.edgec.browserbackend.account.domain.UserPrePaidBilling;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface UserPrePaidBillingRepository extends MongoRepository<UserPrePaidBilling, String>, UserPrePaidBillingRepositoryCustom {

    List<UserPrePaidBilling> findByUsernameAndServicesAndYearAndMonth(String username, String services, int year, int month);

    List<UserPrePaidBilling> findByUsernameAndStatus(String username, BillStatus billStatus);

    List<UserPrePaidBilling> findByUsername(String username);

    Page<UserPrePaidBilling> findAllByYearBetweenAndMonthBetween(Pageable pageable, int year1, int year2, int month1, int month2);

    List<UserPrePaidBilling> findByYearAndMonth(int year, int month);

    List<UserPrePaidBilling> findByStatus(BillStatus status);

}
