package com.edgec.browserbackend.account.repository;

import com.edgec.browserbackend.account.domain.BillStatus;
import com.edgec.browserbackend.account.domain.DeductionRecord;
import com.edgec.browserbackend.account.domain.Services;
import com.edgec.browserbackend.account.domain.UserPrePaidBilling;
import com.edgec.browserbackend.account.dto.BillQueryCriteriaDto;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

public interface UserPrePaidBillingRepositoryCustom {

    long countPrepaidNum(int year, int month);

    float prepaidAmount(int year, int month);

    Page<UserPrePaidBilling> findByUsernameAndChargeTypes(Pageable pageable, String username, String[] chargeTypes, int year, int month, int day, String zoneId);

    Page<UserPrePaidBilling> findBillsByCondition(Pageable pageable, String username, BillQueryCriteriaDto billQueryCriteriaDto, long dayBeginTime, long dayEndTime);

    List<UserPrePaidBilling> findOverviewByYearAndMonthAndService(String username, int year, int month, Services service);

    void upsertBillOwnCost(String name, String services, int year, int month, long timestamp, float potential, float actual, float ownBillCost, float total, BillStatus status, boolean isPrePaid, String user, int chargeType, String target);

    int updateBillStatus(String id, BillStatus fromStatus, BillStatus toStatus, List<DeductionRecord> deductionRecords);

    List<UserPrePaidBilling> findBillStatisticsByUsernameAndService(String username, Services service);

    List<UserPrePaidBilling> findOverviewByYearAndMonth(String username, int year, int month, String zoneId, Services service);


}
