package com.edgec.browserbackend.auth.service.Impl;


import com.edgec.browserbackend.account.domain.Account;
import com.edgec.browserbackend.account.domain.AccountDto;
import com.edgec.browserbackend.account.domain.UserDto;
import com.edgec.browserbackend.account.service.AccountService;
import com.edgec.browserbackend.auth.domain.UsernameToken;
import com.edgec.browserbackend.auth.exception.AuthErrorCode;
import com.edgec.browserbackend.auth.repository.UsernameTokenRepository;
import com.edgec.browserbackend.auth.service.UsernameTokenService;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

@Service
public class UsernameTokenServiceImpl implements UsernameTokenService {

    @Autowired
    private UsernameTokenRepository usernameTokenRepository;

    @Autowired
    private AccountService accountSecrvice;

    @Override
    public List<UsernameToken> selectVpsDtoByParent(String username) {
        List<UserDto> userDtos = accountSecrvice.getAllDesendentUsers(username, 0);
        List<UsernameToken> usernameTokens = userDtos.stream().map(userDto -> {
            return usernameTokenRepository.findByUsername(userDto.getUsername());
        }).filter(Objects::nonNull).collect(Collectors.toList());
        UsernameToken parentToken = usernameTokenRepository.findByUsername(username);
        if (parentToken != null) {
            usernameTokens.add(parentToken);
        }
        return usernameTokens;
    }

    public UsernameToken createUsername(String username) {

        String token = UUID.randomUUID().toString();

        UsernameToken usernameToken = new UsernameToken();
        usernameToken.setToken(token);
        usernameToken.setUsername(username);

        usernameTokenRepository.save(usernameToken);

        return usernameToken;

    }

    @Override
    public UsernameToken getUserToken(String username) {
        return usernameTokenRepository.findByUsername(username);
    }

    public UsernameToken createUserToken(String owner, String targetUser) {
        Account account = accountSecrvice.findByName(targetUser);
        if (owner.equals(account.getParent()) || owner.equals(targetUser)) {
            String token = UUID.randomUUID().toString().replace("-","");
            UsernameToken usernameToken = new UsernameToken();
            usernameToken.setToken(token);
            usernameToken.setUsername(targetUser);
            usernameTokenRepository.save(usernameToken);

            return usernameToken;
        }
        throw new ClientRequestException(AuthErrorCode.AUTHORIZATION_ERROR);
    }

}
