package com.edgec.browserbackend.browser.dto;

import com.edgec.browserbackend.browser.domain.IpResource;
import com.edgec.browserbackend.browser.domain.Shop;
import com.edgec.browserbackend.browser.domain.TransferStatus;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ShopResultDto {

    private String shopId;

    private String shopName;

    private String owner;

    private TransferStatus transferStatus;

    private String group;

    private String shopUrl;

    private String shopPlatform;

    private String shopAccount;

    private String shopPassword;

    private String shopUA;

    private String shopCookie;

    private IpResource bindIp;

    public static ShopResultDto of(Shop shop, String group, IpResource ipResources) {
        ShopResultDto shopResultDto = new ShopResultDto();
        shopResultDto.setShopId(shop.getShopId());
        if (shop.getShopName() != null)
            shopResultDto.setShopName(shop.getShopName());
        if (shop.getShopPlatform() != null)
            shopResultDto.setShopPlatform(shop.getShopPlatform());
        if (shop.getShopPassword() != null)
            shopResultDto.setShopPassword(shop.getShopPassword());
        if (shop.getTransferStatus() != null)
            shopResultDto.setTransferStatus(shop.getTransferStatus());
        if (shop.getOwner() != null)
            shopResultDto.setOwner(shop.getOwner());
        if (shop.getShopUrl() != null)
            shopResultDto.setShopUrl(shop.getShopUrl());
        if (shop.getShopUA() != null)
            shopResultDto.setShopUA(shop.getShopUA());
        if (shop.getShopCookie() != null)
            shopResultDto.setShopCookie(shop.getShopCookie());
        if (shop.getShopAccount() != null)
            shopResultDto.setShopAccount(shop.getShopAccount());
        shopResultDto.setGroup(group);
        shopResultDto.setBindIp(ipResources);
        return shopResultDto;
    }

    public String getShopPlatform() {
        return shopPlatform;
    }

    public void setShopPlatform(String shopPlatform) {
        this.shopPlatform = shopPlatform;
    }

    public String getGroup() {
        return group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getShopPassword() {
        return shopPassword;
    }

    public void setShopPassword(String shopPassword) {
        this.shopPassword = shopPassword;
    }

    public String getShopAccount() {
        return shopAccount;
    }

    public void setShopAccount(String shopAccount) {
        this.shopAccount = shopAccount;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getShopId() {
        return shopId;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }

    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public TransferStatus getTransferStatus() {
        return transferStatus;
    }

    public void setTransferStatus(TransferStatus transferStatus) {
        this.transferStatus = transferStatus;
    }

    public String getShopUrl() {
        return shopUrl;
    }

    public void setShopUrl(String shopUrl) {
        this.shopUrl = shopUrl;
    }

    public IpResource getBindIp() {
        return bindIp;
    }

    public void setBindIp(IpResource bindIp) {
        this.bindIp = bindIp;
    }

    public String getShopUA() {
        return shopUA;
    }

    public void setShopUA(String shopUA) {
        this.shopUA = shopUA;
    }

    public String getShopCookie() {
        return shopCookie;
    }

    public void setShopCookie(String shopCookie) {
        this.shopCookie = shopCookie;
    }
}
