package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.domain.IpResource;
import com.google.gson.internal.$Gson$Preconditions;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;

import java.util.List;

public interface IpResourceRepository extends MongoRepository<IpResource, String> {
    IpResource findByAddrAndIsDeleted(String addr, boolean isDeleted);
    List<IpResource> findByIdInAndIsDeleted(List<String> ipIds, boolean isDeleted);
    List<IpResource> findByOwnerAndIsDeletedAndShopIdIsNull(String owner, boolean isDeleted);
    List<IpResource> findByOwnerAndStatusAndIsDeletedAndShopIdIsNull(String owner, int status, boolean isDeleted);
    List<IpResource> findByStatusAndIdInAndIsDeleted(int status, List<String> ipIds, boolean isDeleted);
    Page<IpResource> findByAddrLikeAndIdInAndIsDeleted(String addr, List<String> ipIds, boolean isDeleted, Pageable pageable);
    Page<IpResource> findByVendorLikeAndIdInAndIsDeleted(String vendor, List<String> ipIds, boolean isDeleted, Pageable pageable);
    Page<IpResource> findByRegionLikeAndIdInAndIsDeleted(String region, List<String> ipIds, boolean isDeleted, Pageable pageable);

    List<IpResource> findByValidTimeBetween(long beginTime, long endTime);

    int countByStatusAndIdInAndIsDeleted(int status, List<String> ipIds, boolean isDeleted);
}
