package com.edgec.browserbackend.browser.service;

import com.edgec.browserbackend.browser.domain.Shop;
import com.edgec.browserbackend.browser.domain.ShopSummary;
import com.edgec.browserbackend.browser.dto.ShopFilterDto;
import com.edgec.browserbackend.browser.dto.ShopPageResultDto;
import com.edgec.browserbackend.browser.dto.ShopResultDto;

import java.util.List;

public interface ShopService {

    String addShop(String useranme, ShopResultDto shopResultDto);

    List<String> addShops(String username, List<Shop> shops);

    String updateShop(String username, ShopResultDto shopResultDto);

    void deleteShop(String username, String shopId);

    void bindShop(String username, String shopId, String ipAddr);

    void unBindShop(String username, String shopId, String ipAddr);

    void transferShop(String username, String shopId, String groupId);

    void assignShops(String username, List<String> shopIds, List<String> users);

    ShopPageResultDto getShopList(String username, String groupId, int page, int amount, ShopFilterDto shopFilterDto);

    ShopSummary getShopSummary(String username);
}
