package com.edgec.browserbackend.browser.task;

import com.alibaba.fastjson.JSONObject;
import com.edgec.browserbackend.account.domain.Account;
import com.edgec.browserbackend.account.repository.AccountRepository;
import com.edgec.browserbackend.browser.domain.IpResource;
import com.edgec.browserbackend.browser.repository.IpResourceRepository;
import com.edgec.browserbackend.common.commons.utils.SmsUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.Instant;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
public class ExpireSoonWarn {

    @Autowired
    private AccountRepository accountRepository;

    @Autowired
    private IpResourceRepository ipResourceRepository;

    @Scheduled(cron = "0 0 1 * * ?")
    public void sendMessages() {
        this.sendExpiredIpAccount(0);
        this.sendExpiredIpAccount(7);
    }

    private void sendExpiredIpAccount(int day) {
        List<IpResource> ipResources = null;
        if (day == 7) {
            ipResources = ipResourceRepository.findByValidTimeBetween(
                    Instant.now().atZone(ZoneOffset.UTC).plusDays(day - 1).toEpochSecond() * 1000,
                    Instant.now().atZone(ZoneOffset.UTC).plusDays(day).toEpochSecond() * 1000);
        } else {
            ipResources = ipResourceRepository.findByValidTimeBetween(
                    Instant.now().atZone(ZoneOffset.UTC).minusDays(1).toEpochSecond() * 1000,
                    Instant.now().atZone(ZoneOffset.UTC).plusDays(day).toEpochSecond() * 1000);
        }

        if (ipResources != null && ipResources.size() > 0) {
            Map<String, List<IpResource>> map = ipResources.stream().collect(Collectors.groupingBy(IpResource::getOwner));
            for (String key : map.keySet()) {
                sendToAccount(key, day, map.get(key).size(), map.get(key).stream().map(x -> x.getAddr()).collect(Collectors.toList()));
            }
        }
    }

    private void sendToAccount(String username, int day, int amount, List<String> ips) {
        Account account = accountRepository.findByName(username);
        JSONObject param = new JSONObject();
        param.put("day", day);
        param.put("amount", amount);
        param.put("ips", ips);
        SmsUtils.sendIpSms(account.getPhoneNumber(), SmsUtils.SmsTemplateCode.VPS_EXPIRE, param);
    }

}
