package com.edgec.browserbackend.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

/**
 * @Desc
 * @Author jason
 * @CreateTime 2020/3/11 7:36 下午
 **/
public class FileUtil {
    private static Logger log = LoggerFactory.getLogger(FileUtil.class);
    private static final String CHARSET = "UTF-8";

    public static String read(File f, String charset) {
        String line = null;
        StringBuffer buf = new StringBuffer();
        try (InputStreamReader reader = new InputStreamReader(new FileInputStream(f), charset);
             BufferedReader br = new BufferedReader(reader);){
            while ((line = br.readLine()) != null) {
                buf.append(line+System.getProperty("line.separator"));
            }
        } catch (Exception e) {
            log.error("[" + f.getName() + "]文件读出失败{}",e);
            return null;
        }
        log.debug("[" + f.getName() + "]文件读出成功");
        return buf.toString();
    }

    public static List<String> readLine(File f, String charset) {
        String line = null;
        List<String> lineList = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        try (InputStreamReader reader = new InputStreamReader(new FileInputStream(f), charset);
             BufferedReader br = new BufferedReader(reader);){
            while ((line = br.readLine()) != null) {
                lineList.add(line);
            }
            br.close();
            reader.close();
        } catch (Exception e) {
            log.error("[" + f.getName() + "]文件读出失败{}",e);
            return null;
        }
        log.debug("[" + f.getName() + "]文件读出成功");
        return lineList;
    }

    public static boolean write(String content, File file) {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file))){
            bw.write(content);
        } catch (Exception e) {
            log.error("[" + file.getName() + "]写入失败{}",e);
            return false;
        }
        log.debug("[" + file.getName() + "]文件写入成功");
        return true;
    }
}
