package com.edgec.browserbackend.account.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.hibernate.validator.constraints.Length;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@NoArgsConstructor
@Getter
@Setter
@Document(collection = "accounts")
@JsonIgnoreProperties(ignoreUnknown = true)
public class Account {

    /**
     * 账户id
     */
    @Id
    private String name;

    /**
     * 父账户
     */
    private String parent;

    /**
     * 子用户使用的密码
     */
    private String password;

    private Date lastSeen;

    private Date signupDate = new Date();

    private String nickname;

    private String email;

    private String companyName;

    private String jobTitle;

    private String phoneNumber;

    private String lockReason;

    private boolean isPrePaid = true;

    private String token;

    private boolean allowedToCreateSubUser = false;

    /**
     * 操作与权重
     * <p>
     * 下载 cookie：1
     * 上传 cookie：2
     * 店铺管理（增删改店铺、绑定与解绑ip）：4
     */
    private int permission = -1;

    /**
     * 注册成功后，当前用户的邀请码相关信息，用于邀请别人获取佣金
     */
    private Promotion promotion;

    /**
     * 注册时，其他用户给当前用户的邀请码
     */
    private String promotionCode;

    private String comment;

    private List<String> whiteList = new ArrayList<>();

    private int childCount = 0;

    private int groupCount = 0;

    private int shopCount = 0;

    /**
     * 0: 未认证; 1: 认证中; 2: 已认证;
     */
    private int authorized;

    private List<String> queryIpUrlList = new ArrayList<>();

    @Length(min = 0, max = 20000)
    private String note;

    public Account(AccountDto account) {
        this.setName(account.getName());
        this.setAllowedToCreateSubUser(account.isAllowedToCreateSubUser());
        this.setCompanyName(account.getCompanyName());
        this.setEmail(account.getEmail());
        this.setJobTitle(account.getJobTitle());
        this.setPhoneNumber(account.getPhoneNumber());
        this.setPermission(account.getPermission());
        this.setWhiteList(account.getWhiteList());
    }


}
