package com.edgec.browserbackend.browser.controller;

import com.alibaba.fastjson.JSONObject;
import com.edgec.browserbackend.account.dto.ResultDto;
import com.edgec.browserbackend.browser.domain.Vps;
import com.edgec.browserbackend.browser.dto.AssignVpsDto;
import com.edgec.browserbackend.browser.dto.PageInfo;
import com.edgec.browserbackend.browser.dto.VpsPageResultDto;
import com.edgec.browserbackend.browser.service.VpsService;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import com.edgec.browserbackend.common.utils.ResponseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.security.Principal;
import java.util.List;

/**
 * @author xuxin
 */
@RestController
@RequestMapping("/vps")
public class VpsController {

    private final Logger log = LoggerFactory.getLogger(VpsController.class);

    @Autowired
    private VpsService vpsService;

    @PostMapping("/add")
    public ResultDto addVps(Principal principal, @Validated @RequestBody Vps vps) {
        String logs = "【addVps】 ";
        log.info("{}, params : {}, {}", logs, principal.getName(), JSONObject.toJSONString(vps));
        try {
            vps.setOwner1(principal.getName());
            return ResponseUtil.success(vpsService.addVps(vps));
        } catch (ClientRequestException e) {
            log.warn("{}, ClientRequestException : {}", logs, e.getErrorCode().getReason());
            return ResponseUtil.error(e.getErrorCode());
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            return ResponseUtil.error(e.getMessage());
        }
    }

    @DeleteMapping("/{id}")
    public ResultDto deleteVps(Principal principal, @PathVariable String id) {
        String logs = "【deleteVps】 ";
        log.info("{}, params : {}, {}", logs, principal.getName(), id);
        try {
            vpsService.deleteVps(principal.getName(), id);
            return ResponseUtil.success();
        } catch (ClientRequestException e) {
            log.warn("{}, ClientRequestException : {}", logs, e.getErrorCode().getReason());
            return ResponseUtil.error(e.getErrorCode());
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            return ResponseUtil.error(e.getMessage());
        }
    }

    @PutMapping("/update")
    public ResultDto updateVps(@RequestBody Vps vps) {
        String logs = "【updateVps】 ";
        log.info("{}, params : {}", logs, JSONObject.toJSONString(vps));
        try {
            vpsService.updateVps(vps);
            return ResponseUtil.success();
        } catch (ClientRequestException e) {
            log.warn("{}, ClientRequestException : {}", logs, e.getErrorCode().getReason());
            return ResponseUtil.error(e.getErrorCode());
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            return ResponseUtil.error(e.getMessage());
        }
    }

    /**
     * 登录
     */
    @GetMapping("/login_vps/{id}")
    public ResultDto getVps(@PathVariable String id) {
        String logs = "【getVps】 ";
        log.info("{}, params : {}", logs, id);
        try {
            return ResponseUtil.success(vpsService.loginVps(id));
        } catch (ClientRequestException e) {
            log.warn("{}, ClientRequestException : {}", logs, e.getErrorCode().getReason());
            return ResponseUtil.error(e.getErrorCode());
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            return ResponseUtil.error(e.getMessage());
        }
    }

    /**
     * 列表
     */
    @GetMapping("/list")
    public ResultDto getVpsList(Principal principal, @RequestParam(value = "page") int page, @RequestParam(value = "size") int size) {
        String logs = "【getVpsList】 ";
        log.info("{}, params : {}, {}, {}", logs, principal.getName(), page, size);
        try {
            Pageable pageable = PageRequest.of(page, size);
            Page<Vps> pageInfo = vpsService.queryPage(principal.getName(), pageable);
            ResultDto resultDto = new ResultDto();
            resultDto.setData(pageInfo);

            /// 临时这样写，有空了得去掉下面三行
            PageInfo pageResult = new PageInfo(pageInfo.getPageable().getPageNumber(), pageInfo.getTotalPages(), (int) pageInfo.getTotalElements());
            return ResponseUtil.success(new VpsPageResultDto<>(pageInfo.getContent(), pageResult));
        } catch (ClientRequestException e) {
            log.warn("{}, ClientRequestException : {}", logs, e.getErrorCode().getReason());
            return ResponseUtil.error(e.getErrorCode());
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            return ResponseUtil.error(e.getMessage());
        }
    }

    /**
     * 分配 vps 给子账户
     */
    @PostMapping("/assign")
    public ResultDto assignVpsList(Principal principal, @RequestBody AssignVpsDto assignVpsDto) {
        String logs = "【assignVpsList】 ";
        log.info("{}, params : {}", logs, JSONObject.toJSONString(assignVpsDto));
        try {
            List<String> list = vpsService.assignVpsList(principal.getName(), assignVpsDto);
            return list.isEmpty() ? ResponseUtil.success() : ResponseUtil.error(list);
        } catch (ClientRequestException e) {
            log.warn("{}, ClientRequestException : {}", logs, e.getErrorCode().getReason());
            return ResponseUtil.error(e.getErrorCode());
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            return ResponseUtil.error(e.getMessage());
        }
    }

    /**
     * 查看当前vps已经绑定的  子用户
     */
    @GetMapping("/list/{id}")
    public ResultDto getVpsList(Principal principal, @PathVariable String id) {
        String logs = "【getVpsList】 ";
        log.info("{}, params : {}", logs, id);
        try {
            return ResponseUtil.success(vpsService.queryAssignUserList(principal.getName(), id));
        } catch (ClientRequestException e) {
            log.warn("{}, ClientRequestException : {}", logs, e.getErrorCode().getReason());
            return ResponseUtil.error(e.getErrorCode());
        } catch (Exception e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            return ResponseUtil.error(e.getMessage());
        }
    }


}
